/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.caching.cache.CacheEntry;
import org.eclipse.dltk.core.caching.cache.CacheIndex;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class ArchiveIndexContentChecker {
    private ZipFile zipFile;
    private EList<EObject> contents;
    private File file;
    private long version;
    private IDLTKLanguageToolkit toolkit;

    public ArchiveIndexContentChecker(File file, long version, IDLTKLanguageToolkit toolkit) {
        this.file = file;
        this.version = version;
        this.toolkit = toolkit;
        try {
            this.zipFile = new ZipFile(file);
            ZipEntry entry = this.zipFile.getEntry(".index");
            XMIResourceImpl indexResource = new XMIResourceImpl(URI.createURI((String)"dltk_cache://zipIndex"));
            indexResource.load((InputStream)new BufferedInputStream(this.zipFile.getInputStream(entry), 8096), null);
            this.contents = indexResource.getContents();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean containChanges() {
        File[] listFiles;
        if (this.contents == null) {
            return true;
        }
        File parent = this.file.getParentFile();
        ArrayList<File> collected = new ArrayList<File>();
        for (EObject eObject : this.contents) {
            CacheIndex cacheIndex = (CacheIndex)eObject;
            EList<CacheEntry> entries = cacheIndex.getEntries();
            for (CacheEntry cacheEntry : entries) {
                String path = cacheEntry.getPath();
                File childFile = new File(parent, path);
                if (!childFile.exists()) {
                    return true;
                }
                if (cacheEntry.getLastAccessTime() != this.version) {
                    return true;
                }
                long timestamp = childFile.lastModified();
                try {
                    File canonicalFile = childFile.getCanonicalFile();
                    if (!canonicalFile.getAbsolutePath().equals(this.file.getAbsolutePath())) {
                        timestamp = canonicalFile.lastModified();
                    }
                }
                catch (IOException e) {
                    return true;
                }
                long cacheStamp = cacheEntry.getTimestamp() / 1000L;
                if (cacheStamp != (timestamp /= 1000L)) {
                    return true;
                }
                collected.add(childFile);
            }
        }
        File[] fileArray = listFiles = parent.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && this.needIndexing(file.getName()) && !collected.contains(file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containChanges(IFileStore store) {
        if (this.contents == null) {
            return true;
        }
        IFileStore parent = store.getParent();
        ArrayList<IFileStore> collected = new ArrayList<IFileStore>();
        for (EObject eObject : this.contents) {
            CacheIndex cacheIndex = (CacheIndex)eObject;
            EList<CacheEntry> entries = cacheIndex.getEntries();
            for (CacheEntry cacheEntry : entries) {
                long cacheStamp;
                String path = cacheEntry.getPath();
                IFileStore childFile = parent.getChild(path);
                IFileInfo childFileInfo = childFile.fetchInfo();
                if (!childFileInfo.exists()) {
                    return true;
                }
                if (cacheEntry.getLastAccessTime() != this.version) {
                    return true;
                }
                long timestamp = childFileInfo.getLastModified();
                if (childFileInfo.getAttribute(32)) {
                    String canonicalFile = childFileInfo.getStringAttribute(64);
                    IFileStore fileStore = childFile.getFileStore((IPath)new Path(canonicalFile));
                    IFileInfo fetchInfo = fileStore.fetchInfo();
                    timestamp = fetchInfo.getLastModified();
                }
                if ((cacheStamp = cacheEntry.getTimestamp() / 1000L) != (timestamp /= 1000L)) {
                    return true;
                }
                collected.add(childFile);
            }
        }
        IFileStore[] listFiles = null;
        try {
            listFiles = parent.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (listFiles != null) {
            IFileStore[] iFileStoreArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore file = iFileStoreArray[n2];
                IFileInfo fileInfo = file.fetchInfo();
                if (!fileInfo.isDirectory() && this.needIndexing(file.getName()) && !collected.contains(file)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean needIndexing(String name) {
        return DLTKContentTypeManager.isValidFileNameForContentType(this.toolkit, (IPath)new Path(name));
    }
}

