/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.IndexerManager;
import org.eclipse.dltk.internal.core.index2.ProgressJob;
import org.eclipse.osgi.util.NLS;

public class RemoveContainerRequest
extends AbstractIndexRequest {
    private final IPath containerPath;

    public RemoveContainerRequest(ProjectIndexer2 indexer, IPath containerPath, ProgressJob progressJob) {
        super(indexer, progressJob);
        this.containerPath = containerPath;
    }

    @Override
    protected String getName() {
        return this.containerPath.toString();
    }

    @Override
    protected void run() throws CoreException, IOException {
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null) {
            return;
        }
        if (this.progressJob != null) {
            IPath path = this.containerPath;
            if (EnvironmentPathUtils.isFull(path)) {
                path = EnvironmentPathUtils.getLocalPath(path);
            }
            this.progressJob.subTask(NLS.bind((String)"cleaning ''{0}''", (Object)path));
        }
        indexer.removeContainer(this.containerPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveContainerRequest other = (RemoveContainerRequest)obj;
        return !(this.containerPath == null ? other.containerPath != null : !this.containerPath.equals((Object)other.containerPath));
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.containerPath == null ? 0 : this.containerPath.hashCode());
        return result;
    }
}

