/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] items;
    private int index;
    private final int endIndex;

    public ArrayIterator(T[] items) {
        this(items, 0, items.length);
    }

    public ArrayIterator(T[] items, int startIndex, int endIndex) {
        this.items = items;
        this.index = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public T next() throws NoSuchElementException {
        try {
            return this.items[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

