/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.DLTKContributionExtensionManager;
import org.eclipse.dltk.internal.launching.debug.DebuggingEngine;
import org.eclipse.dltk.launching.IInterpreterRunnerFactory;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;

public class DebuggingEngineManager
extends DLTKContributionExtensionManager {
    static final String DEBUGGING_ENGINE_EXT_POINT = "org.eclipse.dltk.launching.debuggingEngine";
    private static final String ENGINE_CONTRIBUTION = "engineContribution";
    private static final String ENGINE_TAG = "engine";
    private static DebuggingEngineManager instance;

    public static synchronized DebuggingEngineManager getInstance() {
        if (instance == null) {
            instance = new DebuggingEngineManager();
        }
        return instance;
    }

    public IDebuggingEngine getDebuggingEngine(String id) {
        return (IDebuggingEngine)this.getContributionById(id);
    }

    public IDebuggingEngine getSelectedDebuggingEngine(IProject project, String natureId) {
        return (IDebuggingEngine)this.getSelectedContribution(project, natureId);
    }

    public boolean hasSelectedDebuggingEngine(IProject project, String natureId) {
        return this.getSelectedDebuggingEngine(project, natureId) != null;
    }

    protected boolean isNatureContribution(IConfigurationElement main) {
        return ENGINE_CONTRIBUTION.equals(main.getName());
    }

    protected Object configureContribution(Object object, IConfigurationElement config) {
        return new DebuggingEngine((IInterpreterRunnerFactory)object, config);
    }

    protected String getContributionElementName() {
        return ENGINE_TAG;
    }

    protected String getExtensionPoint() {
        return DEBUGGING_ENGINE_EXT_POINT;
    }

    protected boolean isValidContribution(Object object) {
        return object instanceof IInterpreterRunnerFactory;
    }
}

