/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ScriptEvaluationContextManager
implements IWindowListener,
IDebugContextListener {
    private static final String DEBUGGER_ACTIVE = "org.eclipse.dltk.debug.ui.debuggerActive";
    private static ScriptEvaluationContextManager manager;
    private Map<IWorkbenchPage, IScriptStackFrame> pageToContextMap;
    private IWorkbenchWindow activeWindow;

    protected ScriptEvaluationContextManager() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        this.pageToContextMap = new HashMap<IWorkbenchPage, IScriptStackFrame>();
    }

    public static void startup() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (manager == null) {
                    manager = new ScriptEvaluationContextManager();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        manager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)manager);
                    manager.activeWindow = workbench.getActiveWorkbenchWindow();
                }
            }
        };
        DLTKDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.activeWindow = window;
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    private void setContext(IWorkbenchPage page, IScriptStackFrame frame) {
        this.pageToContextMap.put(page, frame);
        System.setProperty(DEBUGGER_ACTIVE, "true");
    }

    private void removeContext(IWorkbenchPage page) {
        this.pageToContextMap.remove(page);
        if (this.pageToContextMap.isEmpty()) {
            System.setProperty(DEBUGGER_ACTIVE, "false");
        }
    }

    private static IScriptStackFrame getContext(IWorkbenchPage page) {
        if (manager != null && ScriptEvaluationContextManager.manager.pageToContextMap != null) {
            return ScriptEvaluationContextManager.manager.pageToContextMap.get(page);
        }
        return null;
    }

    public static IScriptStackFrame getEvaluationContext(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        IScriptStackFrame frame = ScriptEvaluationContextManager.getContext(page);
        if (frame == null) {
            return ScriptEvaluationContextManager.getEvaluationContext(page.getWorkbenchWindow());
        }
        return frame;
    }

    public static IScriptStackFrame getEvaluationContext(IWorkbenchWindow window) {
        ArrayList<IWorkbenchWindow> alreadyVisited = new ArrayList<IWorkbenchWindow>();
        if (window == null) {
            window = ScriptEvaluationContextManager.manager.activeWindow;
        }
        return ScriptEvaluationContextManager.getEvaluationContext(window, alreadyVisited);
    }

    private static IScriptStackFrame getEvaluationContext(IWorkbenchWindow window, List<IWorkbenchWindow> alreadyVisited) {
        IWorkbenchPage activePage = window.getActivePage();
        IScriptStackFrame frame = null;
        if (activePage != null) {
            frame = ScriptEvaluationContextManager.getContext(activePage);
        }
        if (frame == null) {
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                if (activePage != pages[i] && (frame = ScriptEvaluationContextManager.getContext(pages[i])) != null) {
                    return frame;
                }
                ++i;
            }
            alreadyVisited.add(window);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i2 = 0;
            while (i2 < windows.length) {
                if (!alreadyVisited.contains(windows[i2]) && (frame = ScriptEvaluationContextManager.getEvaluationContext(windows[i2], alreadyVisited)) != null) {
                    return frame;
                }
                ++i2;
            }
            return null;
        }
        return frame;
    }

    public void debugContextChanged(DebugContextEvent event) {
        IWorkbenchPart part;
        if ((event.getFlags() & 1) > 0 && (part = event.getDebugContextProvider().getPart()) != null) {
            IScriptStackFrame frame;
            Object element;
            IStructuredSelection ss;
            IWorkbenchPage page = part.getSite().getPage();
            ISelection selection = event.getContext();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable && (frame = (IScriptStackFrame)((IAdaptable)element).getAdapter(IScriptStackFrame.class)) != null) {
                this.setContext(page, frame);
                return;
            }
            this.removeContext(page);
        }
    }
}

