/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import java.io.InputStream;
import org.eclipse.dltk.dbgp.internal.DbgpRawPacket;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.packets.DbgpNotifyPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPackageProcessor;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPacketWaiter;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponcePacketWaiter;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;
import org.eclipse.dltk.dbgp.internal.packets.IDbgpRawLogger;
import org.w3c.dom.Document;

public class DbgpPacketReceiver
extends DbgpWorkingThread {
    private final DbgpResponcePacketWaiter responseWaiter;
    private final DbgpPacketWaiter notifyWaiter;
    private final DbgpPacketWaiter streamWaiter;
    private final DbgpPackageProcessor packatProcessor;
    private final InputStream input;
    private IDbgpRawLogger logger;

    @Override
    protected void workingCycle() throws Exception {
        try {
            while (!Thread.interrupted()) {
                DbgpRawPacket packet = DbgpRawPacket.readPacket(this.input);
                if (this.logger != null) {
                    this.logger.log(packet);
                }
                this.addDocument(packet.getParsedXml());
            }
        }
        finally {
            this.responseWaiter.terminate();
            this.notifyWaiter.terminate();
            this.streamWaiter.terminate();
        }
    }

    protected void addDocument(Document doc) {
        this.packatProcessor.processPacket(doc, this.notifyWaiter, this.responseWaiter, this.streamWaiter);
    }

    public DbgpNotifyPacket getNotifyPacket() throws InterruptedException {
        return (DbgpNotifyPacket)this.notifyWaiter.waitPacket();
    }

    public DbgpStreamPacket getStreamPacket() throws InterruptedException {
        return (DbgpStreamPacket)this.streamWaiter.waitPacket();
    }

    public DbgpResponsePacket getResponsePacket(int transactionId, int timeout) throws InterruptedException {
        return this.responseWaiter.waitPacket(transactionId, timeout);
    }

    public DbgpPacketReceiver(InputStream input) {
        super("DBGP - Packet receiver");
        if (input == null) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        this.notifyWaiter = new DbgpPacketWaiter();
        this.streamWaiter = new DbgpPacketWaiter();
        this.responseWaiter = new DbgpResponcePacketWaiter();
        this.packatProcessor = new DbgpPackageProcessor();
    }

    public void setLogger(IDbgpRawLogger logger) {
        this.logger = logger;
    }
}

