/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptProposalInfo;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalInfo;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalExtension2;
import org.eclipse.dltk.ui.text.completion.LinkedModeScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ReplacementBuffer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class GenericTypeCompletionProposal
extends LinkedModeScriptCompletionProposal
implements IScriptCompletionProposalExtension2 {
    protected static final char[] TYPE_TRIGGERS = new char[]{'<', ' '};

    public GenericTypeCompletionProposal(CompletionProposal proposal, ScriptContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public String getName() {
        return this.fProposal.getName();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String completion = String.valueOf(this.fProposal.getName());
        if (this.isCamelCaseMatching()) {
            String prefix = this.getPrefix(document, completionOffset);
            return this.getCamelCaseCompound(prefix, completion);
        }
        return completion;
    }

    protected char[] computeTriggerCharacters() {
        return TYPE_TRIGGERS;
    }

    protected char getOpenTrigger() {
        return '<';
    }

    protected char getExitTrigger() {
        return '>';
    }

    protected void computeReplacement(ReplacementBuffer buffer) {
        buffer.append(this.fProposal.getName());
        buffer.append("<");
        this.setCursorPosition(buffer.length());
        GenericType genericType = (GenericType)this.fProposal.getExtraInfo();
        EList variables = genericType.getTypeParameters();
        int i = 0;
        while (i < variables.size()) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.addArgument(((TypeVariable)variables.get(i)).getName());
            ++i;
        }
        buffer.append(">");
    }

    protected ICompletionProposalInfo computeProposalInfo() {
        return new JavaScriptProposalInfo(this.fProposal.getExtraInfo());
    }

    protected Image computeImage() {
        return DLTKUIPlugin.getImageDescriptorRegistry().get(this.fInvocationContext.getLabelProvider().createTypeImageDescriptor(this.fProposal));
    }
}

