/*******************************************************************************
 * Copyright (c) 2005, 2016 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/
package org.eclipse.dltk.ruby.internal.core.search;

import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.AbstractSearchFactory;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.matching.MatchLocator;

public class RubySearchFactory extends AbstractSearchFactory {

	@Override
	public IMatchLocatorParser createMatchParser(MatchLocator locator) {
		return new RubyMatchLocatorParser(locator);
	}

	@Override
	public ISearchPatternProcessor createSearchPatternProcessor() {
		return new RubySearchPatternProcessor();
	}
}
