/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.core.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.MethodCallExpression;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.sh.internal.core.parser.ShellModel;
import org.eclipse.dltk.sh.internal.core.parser.ShellModuleDeclaration;

public class ShellScriptSourceParser
extends AbstractSourceParser {
    private static ShellModel parse(StringReader reader, ShellModuleDeclaration moduleDeclaration) {
        ShellModel model = new ShellModel();
        int lineStart = 0;
        int commentLength = 0;
        HashSet<String> functionNames = new HashSet<String>();
        HashSet<String> varNames = new HashSet<String>();
        MethodDeclaration mDeclaration = null;
        Stack<MethodDeclaration> tmp = new Stack<MethodDeclaration>();
        boolean isPrevLnContinued = false;
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try (BufferedReader bReader = new BufferedReader(reader);){
                String line;
                while ((line = bReader.readLine()) != null) {
                    String varName2;
                    if (line.trim().length() == 0 || line.trim().charAt(0) == '#') {
                        lineStart += line.length() + 1;
                        continue;
                    }
                    if (line.contains("#")) {
                        commentLength = line.substring(line.indexOf(35)).length();
                        line = line.substring(0, line.indexOf(35));
                    }
                    if (line.contains("()")) {
                        int lBracket = line.indexOf(123) == -1 ? 0 : line.indexOf(123);
                        int fPlusEight = line.indexOf("function") == -1 ? 0 : line.indexOf("function") + 8;
                        mDeclaration = new MethodDeclaration(line.substring(fPlusEight, line.indexOf(40)).trim(), lineStart, lineStart + line.length() - 1, lBracket + lineStart, lBracket + lineStart);
                        functionNames.add(line.substring(fPlusEight, line.indexOf(40)).trim());
                        tmp.push(mDeclaration);
                        model.addFunction(mDeclaration);
                    } else if (line.contains("function ")) {
                        int lBracket;
                        int fPlusEight = line.indexOf("function") + 8;
                        int n = lBracket = line.indexOf(123) == -1 ? line.length() : line.indexOf(123) - 1;
                        if (fPlusEight >= line.length() || fPlusEight > lBracket) continue;
                        mDeclaration = new MethodDeclaration(line.substring(fPlusEight, lBracket).trim(), lineStart, lineStart + line.length() - 1, lBracket + lineStart, lBracket + lineStart);
                        functionNames.add(line.substring(fPlusEight, lBracket).trim());
                        tmp.push(mDeclaration);
                        model.addFunction(mDeclaration);
                    } else if (line.trim().equals("}") && mDeclaration != null && !tmp.isEmpty()) {
                        mDeclaration = (MethodDeclaration)tmp.pop();
                        mDeclaration.setEnd(lineStart + line.length());
                    }
                    Pattern assignmentPattern = Pattern.compile("(^|\\W)\\w*=");
                    Matcher matcher = assignmentPattern.matcher(line);
                    if (matcher.find() && ShellScriptSourceParser.isValidName(varName2 = line.substring(matcher.start(), matcher.end() - 1))) {
                        FieldDeclaration variable = new FieldDeclaration(varName2, lineStart + matcher.start(), lineStart + matcher.end(), lineStart + matcher.start(), lineStart + matcher.end());
                        varNames.add(varName2);
                        model.addVariable(variable);
                    }
                    if (line.contains("if ") && !line.contains("elif ")) {
                        mDeclaration = new MethodDeclaration(line.substring(0, line.length()).trim(), lineStart + line.indexOf("if"), lineStart + line.length() - 1, lineStart, lineStart + line.length());
                        model.addStatement(mDeclaration);
                        tmp.push(mDeclaration);
                    } else if (line.trim().equals("fi")) {
                        if (!tmp.isEmpty()) {
                            mDeclaration = (MethodDeclaration)tmp.pop();
                            mDeclaration.setEnd(lineStart + line.indexOf("fi"));
                        }
                    } else if (line.contains("while ")) {
                        mDeclaration = new MethodDeclaration(line.substring(0, line.length()).trim(), lineStart + line.indexOf("while"), lineStart + line.length() - 1, lineStart, lineStart + line.length());
                        model.addStatement(mDeclaration);
                        tmp.push(mDeclaration);
                    } else if (line.contains("until ")) {
                        mDeclaration = new MethodDeclaration(line.substring(0, line.length()).trim(), lineStart + line.indexOf("until"), lineStart + line.length() - 1, lineStart, lineStart + line.length());
                        model.addStatement(mDeclaration);
                        tmp.push(mDeclaration);
                    } else if (line.contains("done ") || line.trim().equals("done")) {
                        if (!tmp.isEmpty()) {
                            mDeclaration = (MethodDeclaration)tmp.pop();
                            mDeclaration.setEnd(lineStart + line.indexOf("done"));
                        }
                    } else if (line.contains("for ")) {
                        mDeclaration = new MethodDeclaration(line.substring(0, line.length()).trim(), lineStart + line.indexOf("for"), lineStart + line.length() - 1, lineStart, lineStart + line.length());
                        model.addStatement(mDeclaration);
                        tmp.push(mDeclaration);
                    } else if (line.contains("case ")) {
                        mDeclaration = new MethodDeclaration(line.substring(0, line.length()).trim(), lineStart + line.indexOf("case"), lineStart + line.length() - 1, lineStart, lineStart + line.length());
                        model.addStatement(mDeclaration);
                        tmp.push(mDeclaration);
                    } else if (line.trim().equals("esac") && !tmp.isEmpty()) {
                        mDeclaration = (MethodDeclaration)tmp.pop();
                        mDeclaration.setEnd(lineStart + line.indexOf("esac"));
                    }
                    if (line.charAt(line.length() - 1) == '\\' && !isPrevLnContinued) {
                        isPrevLnContinued = true;
                        mDeclaration = new MethodDeclaration(line.substring(0, line.length()).trim(), lineStart + line.indexOf(92), lineStart + line.length() - 1, lineStart, lineStart + line.length());
                        tmp.push(mDeclaration);
                        model.addStatement(mDeclaration);
                    } else if (line.charAt(line.length() - 1) == '\\' && isPrevLnContinued) {
                        if (!tmp.isEmpty()) {
                            mDeclaration = (MethodDeclaration)tmp.pop();
                            mDeclaration.setEnd(lineStart + line.indexOf(92));
                            tmp.push(mDeclaration);
                        }
                    } else if (isPrevLnContinued) {
                        isPrevLnContinued = false;
                        if (!tmp.isEmpty()) {
                            mDeclaration = (MethodDeclaration)tmp.pop();
                            mDeclaration.setEnd(lineStart + line.length() - 2);
                        }
                    }
                    for (String funcName : functionNames) {
                        if (!line.contains(funcName)) continue;
                        moduleDeclaration.addStatement((ASTNode)new MethodCallExpression(lineStart + line.indexOf(funcName), lineStart + line.indexOf(funcName) + funcName.length(), null, funcName, null));
                    }
                    for (String varName2 : varNames) {
                        Pattern varRefPattern = Pattern.compile("(^|\\W)\\$\\b" + varName2 + "\\b");
                        Matcher varRefMatcher = varRefPattern.matcher(line);
                        while (varRefMatcher.find()) {
                            moduleDeclaration.addStatement((ASTNode)new VariableReference(lineStart + varRefMatcher.start(), lineStart + varRefMatcher.end(), varName2));
                        }
                    }
                    lineStart += line.length() + commentLength + 1;
                    commentLength = 0;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    private static boolean isValidName(String varName) {
        return varName.matches("\\w+");
    }

    private static void processNode(ShellModel parse, ModuleDeclaration moduleDeclaration) {
        for (MethodDeclaration functionNode : parse.getFunctions()) {
            moduleDeclaration.addStatement((ASTNode)functionNode);
        }
        for (FieldDeclaration variableNode : parse.getVariables()) {
            moduleDeclaration.addStatement((ASTNode)variableNode);
        }
        for (MethodDeclaration statement : parse.getStatements()) {
            moduleDeclaration.addStatement((ASTNode)statement);
        }
    }

    public IModuleDeclaration parse(IModuleSource source, IProblemReporter arg1) {
        ShellModuleDeclaration moduleDeclaration = new ShellModuleDeclaration(source.getSourceContents().length());
        ShellModel shellModel = ShellScriptSourceParser.parse(new StringReader(source.getSourceContents()), moduleDeclaration);
        moduleDeclaration.setFunctions(shellModel.getFunctions());
        moduleDeclaration.setVariables(shellModel.getVariables());
        ShellScriptSourceParser.processNode(shellModel, moduleDeclaration);
        return moduleDeclaration;
    }
}

