/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IDLTKLanguageToolkitExtension;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.index2.AbstractIndexer;
import org.eclipse.dltk.core.index2.IIndexingRequestor;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.index.lucene.DocumentFactory;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.LuceneManager;
import org.eclipse.dltk.internal.core.index.lucene.LuceneSearchEngine;
import org.eclipse.dltk.internal.core.util.Util;

public class LuceneIndexer
extends AbstractIndexer {
    private String fFile;
    private String fContainer;

    public ISearchEngine createSearchEngine() {
        return new LuceneSearchEngine();
    }

    public Map<String, Long> getDocuments(IPath containerPath) {
        IndexSearcher indexSearcher = null;
        String container = containerPath.toString();
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            indexSearcher = (IndexSearcher)LuceneManager.INSTANCE.findTimestampsSearcher(container).acquire();
            indexSearcher.search((Query)new MatchAllDocsQuery(), (Collector)new TimestampsCollector(result));
            HashMap<String, Long> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        finally {
            if (indexSearcher != null) {
                try {
                    LuceneManager.INSTANCE.findTimestampsSearcher(container).release((Object)indexSearcher);
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
        }
        return Collections.emptyMap();
    }

    public void addDeclaration(IIndexingRequestor.DeclarationInfo info) {
        try {
            IndexWriter writer = LuceneManager.INSTANCE.findIndexWriter(this.fContainer, IndexType.DECLARATIONS, info.elementType);
            writer.addDocument((Iterable)DocumentFactory.createForDeclaration(this.fFile, info));
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public void addReference(IIndexingRequestor.ReferenceInfo info) {
        try {
            IndexWriter writer = LuceneManager.INSTANCE.findIndexWriter(this.fContainer, IndexType.REFERENCES, info.elementType);
            writer.addDocument((Iterable)DocumentFactory.createForReference(this.fFile, info));
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public void indexDocument(ISourceModule sourceModule) {
        IFileHandle fileHandle = EnvironmentPathUtils.getFile((IModelElement)sourceModule);
        try {
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)sourceModule);
            if (toolkit == null) {
                return;
            }
            this.resetDocument(sourceModule, toolkit);
            long lastModified = fileHandle == null ? 0L : fileHandle.lastModified();
            LuceneManager.INSTANCE.delete(this.fContainer, this.fFile);
            IndexWriter indexWriter = LuceneManager.INSTANCE.findTimestampsWriter(this.fContainer);
            indexWriter.addDocument((Iterable)DocumentFactory.createForTimestamp(this.fFile, lastModified));
            super.indexDocument(sourceModule);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void removeContainer(IPath containerPath) {
        LuceneManager.INSTANCE.delete(containerPath.toString());
    }

    public void removeDocument(IPath containerPath, String sourceModulePath) {
        LuceneManager.INSTANCE.delete(containerPath.toString(), sourceModulePath);
    }

    private void resetDocument(ISourceModule sourceModule, IDLTKLanguageToolkit toolkit) {
        IPath containerPath = sourceModule instanceof SourceModule ? sourceModule.getScriptProject().getPath() : sourceModule.getAncestor(3).getPath();
        String relativePath = toolkit instanceof IDLTKLanguageToolkitExtension && ((IDLTKLanguageToolkitExtension)toolkit).isArchiveFileName(sourceModule.getPath().toString()) ? ((ExternalSourceModule)sourceModule).getFullPath().toString() : Util.relativePath((IPath)sourceModule.getPath(), (int)containerPath.segmentCount());
        this.fContainer = containerPath.toString();
        this.fFile = relativePath;
    }

    private static final class TimestampsCollector
    implements Collector {
        private static final Set<String> fFields = Collections.singleton("path");
        private final Map<String, Long> fResult;

        public TimestampsCollector(Map<String, Long> result) {
            this.fResult = result;
        }

        public boolean needsScores() {
            return false;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final LeafReader reader = context.reader();
            final NumericDocValues timestampField = context.reader().getNumericDocValues("timestampNDV");
            return new LeafCollector(){

                public void setScorer(Scorer scorer) throws IOException {
                }

                public void collect(int docId) throws IOException {
                    Document document = reader.document(docId, fFields);
                    TimestampsCollector.this.fResult.put(document.get("path"), timestampField.get(docId));
                }
            };
        }
    }
}

