/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.manpages;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPagesMessages;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageFolder;
import org.eclipse.dltk.tcl.ui.manpages.ManPageResource;
import org.eclipse.dltk.tcl.ui.manpages.ManpagesFactory;
import org.eclipse.dltk.tcl.ui.manpages.impl.ManPageResourceImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ManPageLoader {
    private static final String TOP_ELEMENT = "manPages";
    private static final String LOCATION_ELEMENT = "location";
    private static final String LOCATION_PATH_ATTRIBUTE = "path";
    private static final String PAGE_ELEMENT = "page";
    private static final String PAGE_FILE_ATTRIBUTE = "file";
    private static final String PAGE_KEYWORD_ATTRIBUTE = "keyword";

    public static ManPageResource load() {
        return ManPageLoader.read(TclUI.getDefault().getPreferenceStore().getString("doc_man_pages_locations"));
    }

    private static ManPageResourceImpl read(String data) {
        if (data == null || data.length() == 0) {
            return new ManPageResourceImpl();
        }
        if (data.contains("xmlns:xmi") && data.contains("xmi:version")) {
            return ManPageLoader.readXMI(data);
        }
        return ManPageLoader.readXML(data);
    }

    private static ManPageResourceImpl readXMI(String data) {
        ManPageResourceImpl resource = new ManPageResourceImpl();
        try {
            resource.load((InputStream)new URIConverter.ReadableInputStream(data, "UTF-8"), null);
        }
        catch (IOException e) {
            TclUI.error("Error parsing doc_man_pages_locations", e);
        }
        resource.verify();
        return resource;
    }

    private static ManPageResourceImpl readXML(String data) {
        ManPageResourceImpl input = new ManPageResourceImpl();
        Element config = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            config = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
        }
        catch (Exception e) {
            TclUI.error("Error parsing doc_man_pages_locations", e);
            return input;
        }
        if (!config.getNodeName().equalsIgnoreCase(TOP_ELEMENT)) {
            TclUI.error("doc_man_pages_locations - bad top level node");
            return input;
        }
        Documentation documentation = ManpagesFactory.eINSTANCE.createDocumentation();
        documentation.setName(ManPagesMessages.ManPageLoader_0);
        documentation.setDefault(true);
        documentation.setId("CONVERTED");
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase(LOCATION_ELEMENT)) {
                Element location = (Element)node;
                String path = location.getAttribute(LOCATION_PATH_ATTRIBUTE);
                ManPageFolder folder = ManpagesFactory.eINSTANCE.createManPageFolder();
                folder.setPath(path);
                NodeList locationChilds = location.getChildNodes();
                int pages = locationChilds.getLength();
                int j = 0;
                while (j < pages) {
                    node = locationChilds.item(j);
                    type = node.getNodeType();
                    if (type == 1 && node.getNodeName().equalsIgnoreCase(PAGE_ELEMENT)) {
                        Element word = (Element)node;
                        String kw = word.getAttribute(PAGE_KEYWORD_ATTRIBUTE);
                        String file = word.getAttribute(PAGE_FILE_ATTRIBUTE);
                        folder.getKeywords().put((Object)kw, (Object)file);
                    }
                    ++j;
                }
                documentation.getFolders().add((Object)folder);
            }
            ++i;
        }
        return input;
    }
}

