/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.lexer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ruby.formatter.lexer.CharPositionPool;
import org.eclipse.dltk.ruby.formatter.lexer.CharRecord;

public class CharHistory {
    private final CharPositionPool pool;
    private final List history = new ArrayList();

    public CharHistory(CharPositionPool pool) {
        this.pool = pool;
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void addHead(int ch, int column, int offset) {
        this.history.add(0, this.pool.create(ch, column, offset));
    }

    public CharRecord getHead() {
        return (CharRecord)this.history.get(0);
    }

    public void removeHead() {
        CharRecord position = (CharRecord)this.history.remove(0);
        this.pool.release(position);
    }

    public void addTail(int ch, int column, int offset) {
        this.history.add(this.pool.create(ch, column, offset));
    }

    public CharRecord getTail() {
        return (CharRecord)this.history.get(this.history.size() - 1);
    }

    public void removeTail() {
        CharRecord position = (CharRecord)this.history.remove(this.history.size() - 1);
        this.pool.release(position);
    }
}

