/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.search;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.BigNumericLiteral;
import org.eclipse.dltk.ast.expressions.BooleanLiteral;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.FloatNumericLiteral;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.expressions.NilLiteral;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.ruby.ast.IRubyASTVisitor;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.ast.RubyRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;

public class RubyMatchLocatorParser
extends MatchLocatorParser {
    public RubyMatchLocatorParser(MatchLocator locator) {
        super(locator);
    }

    static boolean locationEquals(ASTNode node, Object obj) {
        if (obj == node) {
            return true;
        }
        if (obj instanceof ASTNode) {
            return node.locationMatches((ASTNode)obj);
        }
        return false;
    }

    protected MatchLocatorParser.MatchVisitor getMatchVisitor() {
        return new RubyMatchVisitor();
    }

    private void reportTypeReferenceMatch(ASTNode node, PatternLocator locator) {
        while (node != null) {
            TypeReferenceLocation ref;
            String typeName;
            if (node instanceof RubyColonExpression) {
                typeName = ((RubyColonExpression)node).getName();
                ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), typeName);
                locator.match((TypeReference)ref, this.getNodeSet());
                node = ((RubyColonExpression)node).getLeft();
                continue;
            }
            if (node instanceof ConstantReference) {
                typeName = ((ConstantReference)node).getName();
                ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), typeName);
                locator.match((TypeReference)ref, this.getNodeSet());
                node = null;
                continue;
            }
            node = null;
        }
    }

    private void reportSimpleReferenceMatch(SimpleReference simpleRef, PatternLocator locator) {
        int pos = simpleRef.sourceStart();
        if (pos < 0) {
            pos = 0;
        }
        locator.match((Reference)new SimpleReferenceLocation(pos, pos + simpleRef.getName().length(), simpleRef.getName()), this.getNodeSet());
    }

    protected void processStatement(ASTNode node, PatternLocator locator) {
        if (node == null) {
            return;
        }
        if (node instanceof CallExpression) {
            CallExpression call = (CallExpression)node;
            locator.match(call, this.getNodeSet());
        } else if (node instanceof RubyAliasExpression) {
            RubyAliasExpression alias = (RubyAliasExpression)node;
            MethodDeclarationLocation method = new MethodDeclarationLocation(alias.getNewValue(), alias.sourceStart(), alias.sourceEnd(), alias.sourceStart(), alias.sourceEnd());
            locator.match((MethodDeclaration)method, this.getNodeSet());
        } else if (node instanceof RubyAssignment) {
            RubyAssignment assignment = (RubyAssignment)node;
            ASTNode left = assignment.getLeft();
            if (left instanceof VariableReference) {
                VariableReference var = (VariableReference)left;
                FieldDeclarationLocation field = new FieldDeclarationLocation(var.getName(), var.sourceStart(), var.sourceEnd() - 1, var.sourceStart(), var.sourceEnd() - 1);
                locator.match((FieldDeclaration)field, this.getNodeSet());
            }
        } else if (node instanceof Literal) {
            if (node instanceof RubyRegexpExpression) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "Regexp");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof StringLiteral) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "String");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof BooleanLiteral) {
                BooleanLiteral boolLit = (BooleanLiteral)node;
                TypeReferenceLocation ref = boolLit.boolValue() ? new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "TrueClass") : new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "FalseClass");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof NumericLiteral) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "Fixnum");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof NilLiteral) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "NilClass");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof FloatNumericLiteral) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "Float");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof BigNumericLiteral) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "Bignum");
                locator.match((TypeReference)ref, this.getNodeSet());
            }
        } else if (node instanceof Reference) {
            if (node instanceof RubySymbolReference) {
                TypeReferenceLocation ref = new TypeReferenceLocation(node.sourceStart(), node.sourceEnd(), "Symbol");
                locator.match((TypeReference)ref, this.getNodeSet());
            } else if (node instanceof VariableReference) {
                this.reportSimpleReferenceMatch((SimpleReference)node, locator);
            } else if (node instanceof ConstantReference) {
                this.reportSimpleReferenceMatch((SimpleReference)node, locator);
                this.reportTypeReferenceMatch(node, locator);
            }
        } else if (node instanceof RubyColonExpression) {
            this.reportTypeReferenceMatch(node, locator);
        } else if (node instanceof RubyConstantDeclaration) {
            RubyConstantDeclaration var = (RubyConstantDeclaration)node;
            SimpleReference name = var.getName();
            FieldDeclarationLocation field = new FieldDeclarationLocation(name.getName(), name.sourceStart(), name.sourceEnd(), name.sourceStart(), name.sourceEnd());
            locator.match((FieldDeclaration)field, this.getNodeSet());
        }
    }

    protected TypeReference createSuperTypeReference(TypeDeclaration t, ASTNode superClass) {
        String name = t.resolveSuperClassReference(superClass);
        if (name != null) {
            this.initPatternProcessor();
            if (this.patternProcessor != null) {
                name = this.patternProcessor.extractTypeChars(name);
            }
            return new TypeReferenceLocation(superClass.sourceStart(), superClass.sourceEnd(), name);
        }
        return null;
    }

    private static final class FieldDeclarationLocation
    extends FieldDeclaration {
        private FieldDeclarationLocation(String name, int nameStart, int nameEnd, int declStart, int declEnd) {
            super(name, nameStart, nameEnd, declStart, declEnd);
        }

        public boolean equals(Object obj) {
            return RubyMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }

    private static final class MethodDeclarationLocation
    extends MethodDeclaration {
        private MethodDeclarationLocation(String name, int nameStart, int nameEnd, int declStart, int declEnd) {
            super(name, nameStart, nameEnd, declStart, declEnd);
        }

        public boolean equals(Object obj) {
            return RubyMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }

    protected class RubyMatchVisitor
    extends MatchLocatorParser.MatchVisitor
    implements IRubyASTVisitor {
        protected RubyMatchVisitor() {
            super((MatchLocatorParser)RubyMatchLocatorParser.this);
        }

        public void visitTypeName(ASTNode node) {
        }
    }

    private static final class SimpleReferenceLocation
    extends SimpleReference {
        private SimpleReferenceLocation(int start, int end, String name) {
            super(start, end, name);
        }

        public boolean equals(Object obj) {
            return RubyMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }

    private static final class TypeReferenceLocation
    extends TypeReference {
        private TypeReferenceLocation(int start, int end, String name) {
            super(start, end, name);
        }

        public boolean equals(Object obj) {
            return RubyMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }
}

