/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalInfo;

public class ProposalInfo
implements ICompletionProposalInfo {
    private boolean fScriptdocResolved = false;
    private String fScriptdoc = null;
    protected IModelElement fElement;
    protected String fKeyword;

    public ProposalInfo(IModelElement member) {
        this.fElement = member;
    }

    public ProposalInfo(IScriptProject scriptProject, String keyword) {
        this.fElement = scriptProject;
        this.fKeyword = keyword;
    }

    protected ProposalInfo() {
    }

    public IModelElement getModelElement() throws ModelException {
        return this.fElement;
    }

    public Object getForeignElement() {
        return null;
    }

    public String getKeyword() {
        return this.fKeyword;
    }

    @Override
    public String getInfo(IProgressMonitor monitor) {
        if (!this.fScriptdocResolved) {
            this.fScriptdocResolved = true;
            this.fScriptdoc = this.computeInfo(monitor);
        }
        return this.fScriptdoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            String keyword = this.getKeyword();
            if (keyword != null) {
                return this.extractScriptdoc(keyword);
            }
            IModelElement modelElement = this.getModelElement();
            if (modelElement instanceof IMember) {
                IMember member = (IMember)modelElement;
                return this.extractScriptdoc(member, monitor);
            }
            Object foreignElement = this.getForeignElement();
            if (foreignElement != null) {
                return this.extractScriptdoc(foreignElement, monitor);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        catch (IOException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    private String extractScriptdoc(String content) throws ModelException, IOException {
        if (content == null || this.fElement == null) {
            return null;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.fElement);
        if (toolkit == null) {
            return null;
        }
        Reader reader = ScriptDocumentationAccess.getKeywordDocumentation(toolkit.getNatureId(), this.fElement, content);
        if (reader == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addParagraph(buffer, reader);
        if (buffer.length() == 0) {
            if (!HTMLPrinter.hasEpilog(buffer)) {
                HTMLPrinter.addPageEpilog(buffer);
            }
            return buffer.toString();
        }
        return null;
    }

    private String extractScriptdoc(IMember member, IProgressMonitor monitor) throws ModelException, IOException {
        Reader reader;
        if (member != null && (reader = this.getHTMLContentReader(member, monitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private String extractScriptdoc(Object member, IProgressMonitor monitor) throws ModelException, IOException {
        Reader reader;
        if (member != null && (reader = this.getHTMLContentReader(member, monitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private Reader getHTMLContentReader(IMember member, IProgressMonitor monitor) throws ModelException {
        String nature = null;
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)member);
        if (languageToolkit == null) {
            return null;
        }
        nature = languageToolkit.getNatureId();
        if (nature == null) {
            return null;
        }
        return ScriptDocumentationAccess.getHTMLContentReader(nature, member, true, false);
    }

    private Reader getHTMLContentReader(Object member, IProgressMonitor monitor) throws ModelException {
        IDLTKLanguageToolkit[] languageToolkits;
        IDLTKLanguageToolkit[] iDLTKLanguageToolkitArray = languageToolkits = DLTKLanguageManager.getLanguageToolkits();
        int n = languageToolkits.length;
        int n2 = 0;
        while (n2 < n) {
            IDLTKLanguageToolkit idltkLanguageToolkit = iDLTKLanguageToolkitArray[n2];
            Reader reader = ScriptDocumentationAccess.getHTMLContentReader(idltkLanguageToolkit.getNatureId(), member, true, false);
            if (reader != null) {
                return reader;
            }
            ++n2;
        }
        return null;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

