/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.structure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IClass;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;

public class IncrTclNames {
    private static final String ATTR = IncrTclNames.class.getName();
    private final Map<String, Map<String, IncrTclTypeInfo>> names = new HashMap<String, Map<String, IncrTclTypeInfo>>();
    private static final String TYPE_ATTR = String.valueOf(ATTR) + ".TYPE";

    public static IncrTclNames get(ITclModelBuildContext context) {
        return (IncrTclNames)context.getAttribute(ATTR);
    }

    public static IncrTclNames create(ITclModelBuildContext context) {
        IncrTclNames names = IncrTclNames.get(context);
        if (names == null) {
            names = new IncrTclNames();
            context.setAttribute(ATTR, (Object)names);
        }
        return names;
    }

    public void addType(IClass clazz) {
        String namespace = clazz.getName();
        if (namespace.startsWith("::")) {
            namespace = namespace.substring(2);
        }
        if (namespace.length() == 0) {
            return;
        }
        String[] segments = TclParseUtil.tclSplit((String)namespace);
        if (segments.length == 0) {
            return;
        }
        String lastName = segments[segments.length - 1];
        Map<String, IncrTclTypeInfo> types = this.names.get(lastName);
        if (types == null) {
            types = new HashMap<String, IncrTclTypeInfo>();
            this.names.put(lastName, types);
        }
        if (!types.containsKey(namespace)) {
            types.put(namespace, new IncrTclTypeInfo(segments, clazz));
        }
    }

    public IClass resolve(String name) {
        String[] segments = TclParseUtil.tclSplit((String)name);
        if (segments.length == 0) {
            return null;
        }
        Map<String, IncrTclTypeInfo> types = this.names.get(segments[segments.length - 1]);
        if (types == null) {
            return null;
        }
        for (Map.Entry<String, IncrTclTypeInfo> entry : types.entrySet()) {
            if (!entry.getValue().endsWith(segments)) continue;
            return entry.getValue().clazz;
        }
        return null;
    }

    public static void saveType(ITclModelBuildContext context, IClass clazz) {
        context.setAttribute(TYPE_ATTR, (Object)clazz);
    }

    public static IClass getType(ITclModelBuildContext context) {
        return (IClass)context.getAttribute(TYPE_ATTR);
    }

    static class IncrTclTypeInfo {
        final String[] segments;
        final IClass clazz;

        public IncrTclTypeInfo(String[] segments, IClass clazz) {
            this.segments = segments;
            this.clazz = clazz;
        }

        public boolean endsWith(String[] parts) {
            int pLen = parts.length;
            int sLen = this.segments.length;
            if (pLen <= sLen) {
                int offset = sLen - pLen;
                int i = 0;
                while (i < pLen) {
                    if (!parts[i].equals(this.segments[offset + i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public String getSimpleName() {
            return this.segments[this.segments.length - 1];
        }
    }
}

