/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.index2.search.NewSearchEngine;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.core.search.MethodNameMatchRequestor;
import org.eclipse.dltk.core.search.MethodNameRequestor;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.internal.core.search.MethodNameMatchRequestorWrapper;
import org.eclipse.dltk.internal.core.search.MethodNameRequestorWrapper;
import org.eclipse.dltk.internal.core.search.PatternSearchJob;
import org.eclipse.dltk.internal.core.search.TypeNameMatchRequestorWrapper;
import org.eclipse.dltk.internal.core.search.TypeNameRequestorWrapper;
import org.eclipse.dltk.internal.core.search.matching.MixinPattern;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class SearchEngine {
    private BasicSearchEngine basicEngine;
    private NewSearchEngine newSearchEngine;

    public SearchEngine() {
        this.basicEngine = new BasicSearchEngine();
        this.newSearchEngine = new NewSearchEngine();
    }

    public SearchEngine(ISourceModule[] workingCopies) {
        int length = workingCopies.length;
        ISourceModule[] units = new ISourceModule[length];
        System.arraycopy(workingCopies, 0, units, 0, length);
        this.basicEngine = new BasicSearchEngine(units);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.basicEngine = new BasicSearchEngine(workingCopyOwner);
    }

    public static IDLTKSearchScope createHierarchyScope(IType type) throws ModelException {
        return BasicSearchEngine.createHierarchyScope(type);
    }

    public static IDLTKSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws ModelException {
        return BasicSearchEngine.createHierarchyScope(type, owner);
    }

    public static IDLTKSearchScope createSuperHierarchyScope(IType type) throws ModelException {
        return BasicSearchEngine.createSuperHierarchyScope(type);
    }

    public static IDLTKSearchScope createSuperHierarchyScope(IType type, WorkingCopyOwner owner) throws ModelException {
        return BasicSearchEngine.createSuperHierarchyScope(type, owner);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, IDLTKLanguageToolkit toolkit) {
        return BasicSearchEngine.createSearchScope(elements, toolkit);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement element) {
        return BasicSearchEngine.createSearchScope(new IModelElement[]{element}, DLTKLanguageManager.getLanguageToolkit(element));
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, boolean includeReferencedProjects, IDLTKLanguageToolkit toolkit) {
        return BasicSearchEngine.createSearchScope(elements, includeReferencedProjects, toolkit);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, int includeMask, IDLTKLanguageToolkit toolkit) {
        return BasicSearchEngine.createSearchScope(elements, includeMask, toolkit);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement element, int includeMask) {
        return BasicSearchEngine.createSearchScope(new IModelElement[]{element}, includeMask, DLTKLanguageManager.getLanguageToolkit(element));
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return BasicSearchEngine.createTypeNameMatch(type, modifiers);
    }

    public static IDLTKSearchScope createWorkspaceScope(IDLTKLanguageToolkit toolkit) {
        return BasicSearchEngine.createWorkspaceScope(toolkit);
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return BasicSearchEngine.getDefaultSearchParticipant();
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (this.newSearchEngine.isEnabled(scope.getLanguageToolkit())) {
            this.newSearchEngine.search(pattern, participants, scope, requestor, monitor);
        } else {
            this.basicEngine.search(pattern, participants, scope, requestor, monitor);
        }
    }

    public List searchSourceOnly(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        return this.basicEngine.searchSourceOnly(pattern, participants, scope, monitor);
    }

    public void searchAllTypeNames(char[] packageExactName, char[] typeName, int matchRule, int searchFor, IDLTKSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        this.searchAllTypeNames(packageExactName, 0, typeName, matchRule, searchFor, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IDLTKSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameRequestorWrapper requestorWrapper = new TypeNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllTypeNames(packageName, packageMatchRule, typeName, typeMatchRule, searchFor, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IDLTKSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(packageName, packageMatchRule, typeName, typeMatchRule, searchFor, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, IDLTKSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameRequestorWrapper requestorWrapper = new TypeNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllTypeNames(qualifications, typeNames, 8, 0, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, IDLTKSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(qualifications, typeNames, 8, 0, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchDeclarationsOfAccessedFields(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
        this.basicEngine.searchDeclarationsOfAccessedFields(enclosingElement, requestor, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
        this.basicEngine.searchDeclarationsOfReferencedTypes(enclosingElement, requestor, monitor);
    }

    public void searchDeclarationsOfSentMessages(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
        this.basicEngine.searchDeclarationsOfSentMessages(enclosingElement, requestor, monitor);
    }

    public static ISourceModule[] searchMixinSources(IDLTKSearchScope scope, String key, IDLTKLanguageToolkit toolkit, Map<ISourceModule, Set<String>> keysByModule) {
        return SearchEngine.searchMixinSources(scope, key, toolkit, keysByModule, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ISourceModule[] searchMixinSources(final IDLTKSearchScope scope, String searchPattern, IDLTKLanguageToolkit toolkit, final Map<ISourceModule, Set<String>> keysByModule, IProgressMonitor monitor) {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        long startTime = 0L;
        final HashMap processed = new HashMap();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){
            final HandleFactory factory = new HandleFactory();
            final Set<String> searched = new HashSet<String>();

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                ISourceModule module;
                int indexSeparator = documentPath.indexOf("|");
                if (indexSeparator != -1) {
                    documentPath = documentPath.substring(indexSeparator + 1);
                }
                if ((module = (ISourceModule)processed.get(documentPath)) == null) {
                    if (!this.searched.add(documentPath)) {
                        return true;
                    }
                    Openable openable = this.factory.createOpenable(documentPath, scope);
                    if (openable == null || !(openable instanceof ISourceModule)) {
                        return true;
                    }
                    module = (ISourceModule)((Object)openable);
                    processed.put(documentPath, module);
                }
                if (keysByModule != null) {
                    Set<String> keys;
                    String val = new String(indexRecord.getIndexKey());
                    if (keysByModule.containsKey(module)) {
                        keys = (Set)keysByModule.get(module);
                    } else {
                        keys = new HashSet();
                        keysByModule.put(module, keys);
                    }
                    keys.add(val);
                }
                return true;
            }
        };
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        MixinPattern pattern = new MixinPattern(searchPattern.toCharArray(), 10, toolkit);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        participant.selectMixinIndexes(pattern, scope);
        indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, searchRequestor), 3, monitor);
        p.done(toolkit.getNatureId(), "Search mixin modules", 0L);
        return processed.values().toArray(new ISourceModule[processed.size()]);
    }

    public static ISourceModule[] searchMixinSources(IDLTKSearchScope scope, String key, IDLTKLanguageToolkit toolkit, IProgressMonitor monitor) {
        return SearchEngine.searchMixinSources(scope, key, toolkit, null, monitor);
    }

    public static ISourceModule[] searchMixinSources(IDLTKSearchScope scope, String key, IDLTKLanguageToolkit toolkit) {
        return SearchEngine.searchMixinSources(scope, key, toolkit, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public static String[] searchMixinPatterns(IDLTKSearchScope scope, String key, IDLTKLanguageToolkit toolkit) {
        final ArrayList result = new ArrayList();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                String val = new String(indexRecord.getIndexKey());
                if (!result.contains(val)) {
                    result.add(val);
                }
                return true;
            }
        };
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        int flags = 8;
        if (key.indexOf(42) != -1 || key.indexOf(63) != -1) {
            flags |= 2;
        }
        MixinPattern pattern = new MixinPattern(key.toCharArray(), flags, toolkit);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        participant.selectMixinIndexes(pattern, scope);
        indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, searchRequestor), 3, null);
        return result.toArray(new String[result.size()]);
    }

    public static MethodNameMatch createMethodNameMatch(IMethod method, int modifiers) {
        return BasicSearchEngine.createMethodNameMatch(method, modifiers);
    }

    public void searchAllMethodNames(char[] methodName, int methodMatchRule, int searchFor, IDLTKSearchScope scope, MethodNameMatchRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        MethodNameMatchRequestorWrapper requestorWrapper = new MethodNameMatchRequestorWrapper(nameRequestor, scope);
        this.basicEngine.searchAllMethodNames(methodName, methodMatchRule, searchFor, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllMethodNames(char[] methodName, int methodMatchRule, int searchFor, IDLTKSearchScope scope, MethodNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        MethodNameRequestorWrapper requestorWrapper = new MethodNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllMethodNames(methodName, methodMatchRule, searchFor, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }
}

