/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.rules.CombinedWordRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptCommentScanner
extends AbstractScriptScanner {
    private final String fTodoToken;
    private final String fDefaultTokenProperty;
    private TaskTagMatcher fTaskTagMatcher;
    private final ITodoTaskPreferences preferences;
    protected ScriptSourceViewerConfiguration fConfiguration = null;
    private int state = 0;
    private static final int STATE_START = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_BODY = 2;

    public ScriptCommentScanner(IColorManager manager, IPreferenceStore store, String comment, String todoTag, ITodoTaskPreferences preferences) {
        this(manager, store, comment, todoTag, preferences, true);
    }

    public ScriptCommentScanner(ScriptSourceViewerConfiguration configuration, String comment, String todoTag, ITodoTaskPreferences preferences) {
        this(configuration.getColorManager(), configuration.getPreferenceStore(), comment, todoTag, preferences, false);
        this.fConfiguration = configuration;
        this.initialize();
    }

    public ScriptCommentScanner(IColorManager manager, IPreferenceStore store, String comment, String todoTag, ITodoTaskPreferences preferences, boolean initializeAutomatically) {
        super(manager, store);
        this.fTodoToken = todoTag;
        this.fDefaultTokenProperty = comment;
        this.preferences = preferences;
        if (initializeAutomatically) {
            this.initialize();
        }
    }

    @Override
    protected String[] getTokenProperties() {
        return new String[]{this.fDefaultTokenProperty, this.fTodoToken};
    }

    protected Token getDefaultToken() {
        return this.getToken(this.fDefaultTokenProperty);
    }

    protected Token getTodoToken() {
        return this.getToken(this.fTodoToken);
    }

    @Override
    protected List<IRule> createRules() {
        this.setDefaultReturnToken((IToken)this.getDefaultToken());
        ArrayList<IRule> list = new ArrayList<IRule>();
        list.add(this.createTodoRule());
        return list;
    }

    protected IRule createTodoRule() {
        CombinedWordRule combinedWordRule = new CombinedWordRule(this.createIdentifierDetector(), (IToken)this.getDefaultToken());
        List<CombinedWordRule.WordMatcher> matchers = this.createMatchers();
        if (matchers.size() > 0) {
            int i = 0;
            int n = matchers.size();
            while (i < n) {
                combinedWordRule.addWordMatcher(matchers.get(i));
                ++i;
            }
        }
        return combinedWordRule;
    }

    protected IWordDetector createIdentifierDetector() {
        return new ScriptIdentifierDetector();
    }

    protected List<CombinedWordRule.WordMatcher> createMatchers() {
        ArrayList<CombinedWordRule.WordMatcher> list = new ArrayList<CombinedWordRule.WordMatcher>();
        String[] tasks = this.preferences.getTagNames();
        if (tasks != null && tasks.length != 0) {
            this.fTaskTagMatcher = new TaskTagMatcher((IToken)this.getTodoToken());
            this.fTaskTagMatcher.addTaskTags(tasks);
            this.fTaskTagMatcher.setCaseSensitive(this.preferences.isCaseSensitive());
            list.add(this.fTaskTagMatcher);
        }
        return list;
    }

    @Deprecated
    protected char getCommentChar() {
        return '#';
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTaskTagMatcher != null && event.getProperty().equals("org.eclipse.dltk.coretasks.tags")) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    this.fTaskTagMatcher.addTaskTags(this.preferences.getTagNames());
                }
            }
        } else if (this.fTaskTagMatcher != null && event.getProperty().equals("org.eclipse.dltk.coretasks.case_sensitive")) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                boolean caseSensitive = Boolean.valueOf((String)value);
                this.fTaskTagMatcher.setCaseSensitive(caseSensitive);
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    @Override
    public boolean affectsBehavior(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.dltk.coretasks.tags")) {
            return true;
        }
        if (event.getProperty().equals("org.eclipse.dltk.coretasks.case_sensitive")) {
            return true;
        }
        return super.affectsBehavior(event);
    }

    protected int skipCommentChars() {
        if (this.read() == this.getCommentChar()) {
            return 1;
        }
        this.unread();
        return 0;
    }

    @Override
    public IToken nextToken() {
        int c;
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.state == 0) {
            this.state = 1;
            int count = this.skipCommentChars();
            c = this.read();
            while (c != -1 && (c == 32 || c == 9)) {
                c = this.read();
                ++count;
            }
            this.unread();
            if (count > 0) {
                return this.fDefaultReturnToken;
            }
            if (c == -1) {
                return Token.EOF;
            }
        }
        if (this.state == 1) {
            this.state = 2;
            IToken token = this.fRules[0].evaluate((ICharacterScanner)this);
            if (!token.isUndefined()) {
                return token;
            }
        }
        int count = 0;
        while ((c = this.read()) != -1) {
            ++count;
            if (c == 13) {
                if (this.read() == 10) {
                    ++count;
                } else {
                    this.unread();
                }
                this.state = 0;
                break;
            }
            if (c != 10) continue;
            this.state = 0;
            break;
        }
        return count > 0 ? this.fDefaultReturnToken : Token.EOF;
    }

    private static class ScriptIdentifierDetector
    implements IWordDetector {
        private ScriptIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private static class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map<CombinedWordRule.CharacterBuffer, IToken> fUppercaseWords = new HashMap<CombinedWordRule.CharacterBuffer, IToken>();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken token) {
            this.fToken = token;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String[] tasks) {
            int i = 0;
            while (i < tasks.length) {
                if (tasks[i].length() > 0) {
                    this.addWord(tasks[i], this.fToken);
                }
                ++i;
            }
        }

        public synchronized void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            super.addWord(word, token);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(word.toUpperCase()), token);
        }

        public synchronized IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            if (this.fCaseSensitive) {
                return super.evaluate(scanner, word);
            }
            this.fBuffer.clear();
            int i = 0;
            int n = word.length();
            while (i < n) {
                this.fBuffer.append(Character.toUpperCase(word.charAt(i)));
                ++i;
            }
            IToken token = this.fUppercaseWords.get(this.fBuffer);
            if (token != null) {
                return token;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.fCaseSensitive = caseSensitive;
        }
    }
}

