/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.ExpressionConstants;

public class RubyBinaryExpression
extends ASTNode
implements ExpressionConstants {
    private ASTNode left;
    private ASTNode right;
    protected int kind;

    public RubyBinaryExpression(ASTNode left, int kind, ASTNode right) {
        if (left != null) {
            this.setStart(left.sourceStart());
        }
        if (right != null) {
            this.setEnd(right.sourceEnd());
        }
        this.kind = kind;
        this.left = left;
        this.right = right;
    }

    public ASTNode getLeft() {
        return this.left;
    }

    public ASTNode getRight() {
        return this.right;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((ASTNode)this)) {
            if (this.left != null) {
                this.left.traverse(pVisitor);
            }
            if (this.right != null) {
                this.right.traverse(pVisitor);
            }
            pVisitor.endvisit((ASTNode)this);
        }
    }

    public int getKind() {
        return this.kind;
    }
}

