/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.internal.core.TypeSystems;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;

public class RClassType
extends RType
implements IRClassType {
    @Nullable
    protected final Type type;
    @Nullable
    protected final IRTypeDeclaration declaration;

    protected RClassType(ITypeSystem typeSystem, Type type) {
        this.type = type;
        this.declaration = type != null ? typeSystem.convert(type) : null;
    }

    protected RClassType(@Nullable IRTypeDeclaration declaration) {
        this.type = declaration != null ? declaration.getSource() : null;
        this.declaration = declaration;
    }

    public String getRawName() {
        if (this.type != null) {
            if (this.type.eIsProxy()) {
                URI uri = ((InternalEObject)this.type).eProxyURI();
                if (uri != null) {
                    return URI.decode((String)uri.fragment());
                }
            } else {
                return this.type.getName();
            }
        }
        return null;
    }

    public String getName() {
        String rawName = this.getRawName();
        return rawName != null ? "Class<" + rawName + ">" : "Class";
    }

    public Type getTarget() {
        return this.declaration != null ? this.declaration.getSource() : null;
    }

    public IRTypeDeclaration getDeclaration() {
        return this.declaration;
    }

    public IRType toItemType() {
        if (this.type == null) {
            return RTypes.any();
        }
        if (Types.ARRAY == this.type) {
            return RTypes.arrayOf(TypeSystems.GLOBAL, RTypes.none());
        }
        return this.type.toRType(this.declaration.getTypeSystem());
    }

    public IRType newItemType() {
        if (this.type == null) {
            return RTypes.any();
        }
        if (Types.ARRAY == this.type) {
            return RTypes.arrayOf(TypeSystems.GLOBAL, RTypes.any());
        }
        return this.type.createInstance(this.declaration.getTypeSystem());
    }

    public int hashCode() {
        return this.declaration != null ? this.declaration.hashCode() : 31;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RClassType) {
            RClassType other = (RClassType)obj;
            return this.declaration != null ? this.declaration.equals(other.declaration) : other.declaration == null;
        }
        return false;
    }

    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof RClassType) {
            if (this.declaration == null) {
                return TypeCompatibility.TRUE;
            }
            IRTypeDeclaration other = ((RClassType)type).declaration;
            if (other == null) {
                return TypeCompatibility.TRUE;
            }
            return this.declaration.isAssignableFrom(other);
        }
        return TypeCompatibility.FALSE;
    }
}

