/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.internal.javascript.ti.ILazyValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValue2;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueReferenceUtil {
    public static String getLazyName(IValueReference reference) {
        if (reference instanceof IValueProvider) {
            ILazyValue iLazyValue;
            IValue value = ((IValueProvider)((Object)reference)).getValue();
            if (value instanceof ILazyValue && !(iLazyValue = (ILazyValue)((Object)value)).isResolved()) {
                iLazyValue.resolve();
                if (!iLazyValue.isResolved()) {
                    return iLazyValue.getLazyName();
                }
            }
            if (value instanceof IValue2) {
                for (IValue iValue : ((IValue2)value).getReferences()) {
                    ILazyValue lazyValue2;
                    if (!(iValue instanceof ILazyValue) || (lazyValue2 = (ILazyValue)((Object)iValue)).isResolved()) continue;
                    lazyValue2.resolve();
                    if (lazyValue2.isResolved()) continue;
                    return lazyValue2.getLazyName();
                }
            }
        }
        return null;
    }

    public static <E> E extractElement(IValueReference reference, Class<E> elementType) {
        assert (IRMember.class.isAssignableFrom(elementType) || Member.class.isAssignableFrom(elementType));
        Object value = reference.getAttribute("ELEMENT");
        if (value != null) {
            if (value instanceof Object[]) {
                value = ((Object[])value)[0];
            }
            return ValueReferenceUtil.cast(value, elementType);
        }
        return null;
    }

    public static <E> List<E> extractElements(IValueReference reference, Class<E> elementType) {
        assert (IRMember.class.isAssignableFrom(elementType) || Member.class.isAssignableFrom(elementType));
        Object value = reference.getAttribute("ELEMENT");
        if (value != null) {
            if (value instanceof Object[]) {
                Object[] elements = (Object[])value;
                ArrayList<E> result = null;
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    E casted = ValueReferenceUtil.cast(element, elementType);
                    if (casted != null) {
                        if (result == null) {
                            result = new ArrayList<E>(elements.length);
                        }
                        result.add(casted);
                    }
                    ++n2;
                }
                return result;
            }
            E casted = ValueReferenceUtil.cast(value, elementType);
            if (casted != null) {
                return Collections.singletonList(casted);
            }
        }
        return null;
    }

    private static <E> E cast(Object value, Class<E> elementType) {
        Object source;
        if (elementType.isInstance(value)) {
            return (E)value;
        }
        if (elementType == Method.class) {
            if (value instanceof IRMember) {
                Object source2 = ((IRMember)value).getSource();
                if (elementType.isInstance(source2)) {
                    return (E)source2;
                }
                if (source2 instanceof Type) {
                    return (E)((Type)source2).getStaticConstructor();
                }
            } else if (value instanceof Type) {
                return (E)((Type)value).getStaticConstructor();
            }
        } else if (Member.class.isAssignableFrom(elementType) && value instanceof IRMember && elementType.isInstance(source = ((IRMember)value).getSource())) {
            return (E)source;
        }
        return null;
    }
}

