/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.List;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMethodFunctionWrapper
implements IRMethod {
    private final IRFunctionType functionType;

    public RMethodFunctionWrapper(IRFunctionType functionType) {
        this.functionType = functionType;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public Visibility getVisibility() {
        return Visibility.PUBLIC;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public IRType getType() {
        return this.functionType.getReturnType();
    }

    @Override
    public Set<IProblemCategory> getSuppressedWarnings() {
        return null;
    }

    @Override
    public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
        return false;
    }

    @Override
    public int getParameterCount() {
        return this.functionType.getParameters().size();
    }

    @Override
    public List<IRParameter> getParameters() {
        return this.functionType.getParameters();
    }

    @Override
    public boolean isTyped() {
        if (this.functionType.getReturnType() != null) {
            return true;
        }
        List<IRParameter> params = this.functionType.getParameters();
        return params.size() != 1 || !RMethodFunctionWrapper.isVarArgAny(params.get(0));
    }

    private static boolean isVarArgAny(IRParameter parameter) {
        return parameter.getKind() == ParameterKind.VARARGS && parameter.getType() == RTypes.any();
    }

    @Override
    public Object getSource() {
        return this.functionType;
    }

    @Override
    public IRTypeDeclaration getDeclaringType() {
        return null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }
}

