/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemCategoryManager;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.internal.javascript.ti.JSDocProblem;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.core.JavaScriptLanguageUtil;
import org.eclipse.dltk.javascript.parser.JSProblemIdentifier;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.ProblemReporter;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTags;
import org.eclipse.dltk.javascript.parser.jsdoc.SimpleJSDocParser;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.JSDocParseException;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParser;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.RecordProperty;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocSupport
implements IModelBuilder {
    public static final String PARAM_DOTS = "...";
    public static final String PARAM_OPTIONAL = "=";
    protected static final List<NamedValue<Visibility>> STANDARD_ACCESS_MODIFIERS;
    public static final String[] TYPE_TAGS;

    static {
        ArrayList<NamedValue<Visibility>> modifiers = new ArrayList<NamedValue<Visibility>>(3);
        modifiers.add(NamedValue.of("@public", Visibility.PUBLIC));
        modifiers.add(NamedValue.of("@protected", Visibility.PROTECTED));
        modifiers.add(NamedValue.of("@private", Visibility.PRIVATE));
        STANDARD_ACCESS_MODIFIERS = modifiers;
        TYPE_TAGS = new String[]{"@type"};
    }

    @Override
    public String getFeatureId() {
        return JSDocSupport.class.getName();
    }

    @Override
    public int priorityFor(ITypeInfoContext context) {
        return 0;
    }

    public static JSDocTags parse(Comment comment) {
        return new SimpleJSDocParser().parse(comment.getText(), comment.sourceStart());
    }

    @Override
    public void processMethod(FunctionStatement statement, IModelBuilder.IMethod method, JSProblemReporter reporter, ITypeChecker typeChecker) {
        Comment comment = JSDocSupport.getComment((JSNode)statement);
        if (comment == null) {
            return;
        }
        JSDocTags tags = JSDocSupport.parse(comment);
        this.processMethod(method, statement.isDeclaration() ? JSDocFunctionContext.DECLARATION : JSDocFunctionContext.EXPRESSION, tags, reporter, typeChecker);
    }

    public final void processMethod(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, ITypeChecker typeChecker) {
        this.processMethod(method, JSDocFunctionContext.EXPRESSION, tags, reporter, typeChecker);
    }

    public void processMethod(IModelBuilder.IMethod method, JSDocFunctionContext context, JSDocTags tags, JSProblemReporter reporter, ITypeChecker typeChecker) {
        if (method.getType() == null) {
            this.parseType(method, tags, context.getReturnTags(), reporter, typeChecker);
        }
        this.parseParams(method, tags, reporter, typeChecker);
        this.parseThis(method, tags, reporter, typeChecker);
        this.parseDeprecation(method, tags, reporter);
        this.parseAccessModifiers(method, tags, reporter);
        this.parseConstructor(method, tags, reporter);
        this.parseExtends(method, tags, reporter, typeChecker);
        this.parseThrows(method, tags, reporter, typeChecker);
        this.parseSuppressWarnings(method, tags, reporter);
    }

    private void parseExtends(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, ITypeChecker typeChecker) {
        JSDocTag extendsTag = tags.get("@extends");
        if (extendsTag != null) {
            JSType type = this.parseType(extendsTag, false, reporter);
            if (type != null) {
                if (typeChecker != null) {
                    typeChecker.checkType(type, (ISourceNode)extendsTag);
                }
                method.setExtendsType(type);
            }
            this.validateSingleTag(tags, "@extends", reporter);
        }
    }

    protected void parseSuppressWarnings(IModelBuilder.IElement element, JSDocTags tags, JSProblemReporter reporter) {
        List suppressWarnings = tags.list("@SuppressWarnings");
        if (!suppressWarnings.isEmpty()) {
            for (JSDocTag tag : suppressWarnings) {
                this.processSuppressWarnings(tag, new CountingReporter(reporter), element);
            }
        }
    }

    private void parseThrows(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, ITypeChecker typeChecker) {
        if (typeChecker != null) {
            List throwsTags = tags.list("@throws");
            for (JSDocTag throwsTag : throwsTags) {
                String value = throwsTag.value();
                String[] split = value.split(" ");
                if (split.length <= 0 || !JSDocSupport.isBraced(split[0])) continue;
                JSType type = this.translateTypeName(JSDocSupport.cutBraces(split[0]), throwsTag, reporter);
                typeChecker.checkType(type, (ISourceNode)throwsTag);
            }
        }
    }

    public static Comment getCallComment(CallExpression call) {
        CallExpression node = call;
        while (node != null) {
            Comment doc;
            if (node instanceof JSNode && (doc = ((JSNode)node).getDocumentation()) != null) {
                return doc;
            }
            if (node instanceof Statement || !(node instanceof JSNode)) break;
            node = ((JSNode)node).getParent();
        }
        return null;
    }

    @Deprecated
    public static Comment getFunctionComment(FunctionStatement statement) {
        return JSDocSupport.getComment((JSNode)statement);
    }

    public static Comment getComment(JSNode statement) {
        Comment documentation = statement.getDocumentation();
        if (documentation != null) {
            return documentation;
        }
        JSNode parent = statement.getParent();
        if (parent instanceof BinaryOperation) {
            BinaryOperation binary = (BinaryOperation)parent;
            if (binary.getOperation() == 104 && binary.getRightExpression() == statement && (documentation = binary.getLeftExpression().getDocumentation()) != null) {
                return documentation;
            }
        } else if (parent instanceof PropertyInitializer) {
            PropertyInitializer property = (PropertyInitializer)parent;
            if (property.getValue() == statement && (documentation = property.getName().getDocumentation()) != null) {
                return documentation;
            }
        } else if (parent instanceof VariableDeclaration) {
            VariableDeclaration variable = (VariableDeclaration)parent;
            if ((variable.getInitializer() == statement || variable.getIdentifier() == statement) && variable.getParent() instanceof VariableStatement) {
                return ((VariableStatement)variable.getParent()).getDocumentation();
            }
        } else if (parent instanceof PropertyExpression) {
            return JSDocSupport.getComment((JSNode)((PropertyExpression)parent));
        }
        return null;
    }

    private void parseConstructor(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter) {
        if (tags.get("@constructor") != null) {
            method.setConstructor(true);
            this.validateSingleTag(tags, "@constructor", reporter);
        }
    }

    protected List<NamedValue<Visibility>> getSupportedAccessModifiers() {
        return STANDARD_ACCESS_MODIFIERS;
    }

    public void parseAccessModifiers(IModelBuilder.IMember member, JSDocTags tags, JSProblemReporter reporter) {
        List<NamedValue<Visibility>> accessModifiers = this.getSupportedAccessModifiers();
        int i = 0;
        while (i < accessModifiers.size()) {
            NamedValue<Visibility> pair = accessModifiers.get(i);
            JSDocTag tag = tags.get(pair.name);
            if (tag != null) {
                member.setVisibility((Visibility)((Object)pair.value));
                int extraTags = tags.count(pair.name) - 1;
                int j = i + 1;
                while (extraTags == 0 && j < accessModifiers.size()) {
                    extraTags += tags.count(accessModifiers.get((int)j).name);
                    ++j;
                }
                if (extraTags <= 0) break;
                ArrayList all = new ArrayList();
                all.addAll(tags.list(pair.name));
                all.remove(tag);
                int j2 = i + 1;
                while (j2 < accessModifiers.size()) {
                    all.addAll(tags.list(accessModifiers.get((int)j2).name));
                    ++j2;
                }
                for (JSDocTag t : all) {
                    this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.IGNORED_TAG, t, t.name(), tag.name());
                }
                break;
            }
            ++i;
        }
    }

    private void validateSingleTag(JSDocTags tags, String tagName, JSProblemReporter reporter) {
        if (reporter != null && tags.count(tagName) > 1) {
            List t = tags.list(tagName);
            for (JSDocTag tag : t.subList(1, t.size())) {
                this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_TAG, tag, tag.name());
            }
        }
    }

    @Override
    public void processVariable(VariableDeclaration declaration, IModelBuilder.IVariable variable, JSProblemReporter reporter, ITypeChecker typeChecker) {
        Comment comment = declaration.getDocumentation();
        if (comment == null) {
            IVariableStatement statement = declaration.getStatement();
            List vars = statement.getVariables();
            if (!vars.isEmpty() && vars.get(0) == declaration) {
                comment = statement.getDocumentation();
                if (comment == null) {
                    return;
                }
            } else {
                return;
            }
        }
        JSDocTags tags = JSDocSupport.parse(comment);
        if (variable.getType() == null) {
            this.parseType(variable, tags, TYPE_TAGS, reporter, typeChecker);
        }
        this.parseDeprecation(variable, tags, reporter);
        this.parseAccessModifiers(variable, tags, reporter);
        this.parseSuppressWarnings(variable, tags, reporter);
    }

    private void parseThis(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, ITypeChecker typeChecker) {
        JSDocTag thisTag = tags.get("@this");
        if (thisTag != null) {
            JSType type = this.parseType(thisTag, false, reporter);
            if (type != null) {
                if (typeChecker != null) {
                    typeChecker.checkType(type, (ISourceNode)thisTag);
                }
                method.setThisType(type);
            }
            this.validateSingleTag(tags, "@this", reporter);
        }
    }

    public void parseDeprecation(IModelBuilder.IMember member, JSDocTags tags, JSProblemReporter reporter) {
        if (tags.get("@deprecated") != null) {
            member.setDeprecated(true);
            this.validateSingleTag(tags, "@deprecated", reporter);
        }
    }

    protected void parseParams(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, ITypeChecker typeChecker) {
        List paramTags = tags.list("@param");
        if (paramTags.isEmpty()) {
            return;
        }
        int problemCount = 0;
        HashMap<String, RecordType> objectPropertiesTypes = new HashMap<String, RecordType>();
        HashSet<String> processedParams = new HashSet<String>();
        ParamInfo pp = new ParamInfo();
        for (JSDocTag tag : paramTags) {
            String token;
            pp.clear();
            TagTokenizer st = new TagTokenizer(tag);
            if (st.hasMoreTokens() && JSDocSupport.isBraced(token = st.peek())) {
                String type = JSDocSupport.cutBraces(token);
                if (type.startsWith(PARAM_DOTS)) {
                    pp.varargs = true;
                    type = type.substring(PARAM_DOTS.length());
                } else if (type.endsWith(PARAM_DOTS)) {
                    pp.varargs = true;
                    type = type.substring(0, type.length() - PARAM_DOTS.length());
                } else if (type.endsWith(PARAM_OPTIONAL)) {
                    type = type.substring(0, type.length() - PARAM_OPTIONAL.length());
                    pp.optional = true;
                }
                pp.type = type;
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                String paramName = st.nextToken();
                if (paramName.startsWith("[") && paramName.endsWith("]")) {
                    pp.optional = true;
                    int defaultValueSeperatorIndex = (paramName = paramName.substring(1, paramName.length() - 1)).indexOf(61);
                    if (defaultValueSeperatorIndex != -1) {
                        paramName = paramName.substring(0, defaultValueSeperatorIndex);
                    }
                }
                if (!pp.varargs && paramName.endsWith(PARAM_DOTS)) {
                    pp.varargs = true;
                    paramName = paramName.substring(0, paramName.length() - PARAM_DOTS.length());
                }
                String propertyName = null;
                int propertiesObjectIndex = paramName.lastIndexOf(46);
                if (propertiesObjectIndex != -1 && JavaScriptLanguageUtil.isValidIdentifier((String)(propertyName = paramName.substring(propertiesObjectIndex + 1)))) {
                    String objectName = paramName.substring(0, propertiesObjectIndex);
                    RecordType propertiesType = (RecordType)objectPropertiesTypes.get(objectName);
                    if (propertiesType == null) {
                        propertiesType = TypeInfoModelFactory.eINSTANCE.createRecordType();
                        propertiesType.setTypeName(String.valueOf('{') + objectName + '}');
                        objectPropertiesTypes.put(objectName, propertiesType);
                        IModelBuilder.IParameter param = method.getParameter(objectName);
                        if (param != null) {
                            param.setType(propertiesType);
                        } else {
                            int index = objectName.lastIndexOf(46);
                            if (index == -1) {
                                ++problemCount;
                                this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.UNKNOWN_PARAM, tag, objectName);
                            } else {
                                RecordType parentRecordType = (RecordType)objectPropertiesTypes.get(objectName.substring(0, index));
                                if (parentRecordType != null) {
                                    String memberName = objectName.substring(index + 1);
                                    EList<Member> members = parentRecordType.getMembers();
                                    for (Member member : members) {
                                        if (!member.getName().equals(memberName)) continue;
                                        member.setType(propertiesType);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    RecordProperty property = TypeInfoModelFactory.eINSTANCE.createRecordProperty();
                    property.setName(propertyName);
                    if (pp.type != null) {
                        JSType type = this.translateTypeName(pp.type, tag, reporter);
                        if (typeChecker != null) {
                            typeChecker.checkType(type, (ISourceNode)tag);
                        }
                        property.setType(type);
                    }
                    property.setOptional(pp.optional);
                    propertiesType.getMembers().add((Object)property);
                    continue;
                }
                if (method.getParameter(paramName) != null && !processedParams.add(paramName)) {
                    ++problemCount;
                    this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_PARAM, tag, paramName);
                    continue;
                }
                IModelBuilder.IParameter parameter = method.getParameter(paramName);
                if (parameter != null) {
                    if (!pp.optional && st.hasMoreTokens() && st.nextToken().equals("optional")) {
                        pp.optional = true;
                    }
                    this.updateParameter(tag, parameter, pp, reporter, typeChecker);
                    continue;
                }
                if (pp.varargs) {
                    parameter = method.createParameter();
                    parameter.setName(paramName);
                    this.updateParameter(tag, parameter, pp, reporter, typeChecker);
                    method.getParameters().add(parameter);
                    processedParams.add(paramName);
                    continue;
                }
                ++problemCount;
                this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.UNKNOWN_PARAM, tag, paramName);
                continue;
            }
            ++problemCount;
            this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.MISSING_PARAMETER_NAME, tag, new Object[0]);
        }
        if (problemCount == 0 && reporter != null) {
            for (IModelBuilder.IParameter parameter : method.getParameters()) {
                if (processedParams.contains(parameter.getName()) || objectPropertiesTypes.containsKey(parameter.getName())) continue;
                ReferenceLocation location = parameter.getLocation();
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.PARAMETER_MISSING_ANNOTATION, JSDocProblem.PARAMETER_MISSING_ANNOTATION.formatMessage(parameter.getName()), location.getNameStart(), location.getNameEnd());
            }
        }
    }

    protected void updateParameter(JSDocTag tag, IModelBuilder.IParameter parameter, ParamInfo pp, JSProblemReporter reporter, ITypeChecker typeChecker) {
        if (pp.type != null && parameter.getType() == null) {
            JSType type = this.translateTypeName(pp.type, tag, reporter);
            if (typeChecker != null) {
                typeChecker.checkType(type, (ISourceNode)tag);
            }
            parameter.setType(type);
        }
        if (pp.varargs) {
            parameter.setKind(ParameterKind.VARARGS);
        } else if (pp.optional) {
            parameter.setKind(ParameterKind.OPTIONAL);
        }
    }

    public void parseType(IModelBuilder.IElement member, JSDocTags tags, String[] tagNames, JSProblemReporter reporter, ITypeChecker typeChecker) {
        JSDocTag tag = tags.get(tagNames);
        if (tag != null) {
            JSType type;
            int count;
            if (reporter != null && (count = tags.count(tagNames)) > 1) {
                for (JSDocTag t : tags.list(tagNames).subList(1, count)) {
                    if (t.name().equals(tag.name())) {
                        this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_TAG, t, t.name());
                        continue;
                    }
                    this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_TAG, String.valueOf(JSDocProblem.DUPLICATE_TAG.formatMessage(t.name())) + " (was " + tag.name() + ")", t);
                }
            }
            if ((type = this.parseType(tag, this.requireBraces(tag.name()), reporter)) != null) {
                if (typeChecker != null) {
                    typeChecker.checkType(type, (ISourceNode)tag);
                }
                member.setType(type);
            }
        }
    }

    public JSType parseType(JSDocTag tag, boolean requireBraces, JSProblemReporter reporter) {
        TagTokenizer st = new TagTokenizer(tag);
        if (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            if (!requireBraces || JSDocSupport.isBraced(typeName)) {
                return this.translateTypeName(JSDocSupport.cutBraces(typeName), tag, reporter);
            }
        } else if (!requireBraces) {
            this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.WRONG_TYPE_SYNTAX, "Missing type name", tag);
        }
        return null;
    }

    protected boolean requireBraces(String tagName) {
        return "@return".equals(tagName) || "@returns".equals(tagName);
    }

    private void reportProblem(JSProblemReporter reporter, JSProblemIdentifier problemIdentifier, JSDocTag tag, Object ... args) {
        if (reporter != null) {
            reporter.reportProblem((IProblemIdentifier)problemIdentifier, problemIdentifier.formatMessage(args), tag.start(), tag.end());
        }
    }

    private void reportProblem(JSProblemReporter reporter, JSProblemIdentifier problemIdentifier, String message, JSDocTag tag) {
        if (reporter != null) {
            reporter.reportProblem((IProblemIdentifier)problemIdentifier, message, tag.start(), tag.end());
        }
    }

    protected JSType translateTypeName(String typeName, JSDocTag tag, JSProblemReporter reporter) {
        JSDocTypeParser parser = this.createTypeParser();
        try {
            return parser.parse(typeName);
        }
        catch (JSDocParseException e) {
            if (reporter != null) {
                reporter.reportProblem(e.problemId, e.getMessage(), tag.start(), tag.end());
            }
            return null;
        }
        catch (ParseException e) {
            if (reporter != null) {
                String message = e.getMessage();
                if (e.getErrorOffset() >= 0) {
                    message = String.valueOf(message) + " after " + typeName.substring(0, e.getErrorOffset());
                }
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_TYPE_SYNTAX, message, tag.start(), tag.end());
            }
            return null;
        }
    }

    public JSDocTypeParser createTypeParser() {
        return new JSDocTypeParser();
    }

    public static String cutBraces(String typeName) {
        if (JSDocSupport.isBraced(typeName)) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        return typeName;
    }

    public static boolean isBraced(String typeName) {
        int length = typeName.length();
        return length > 2 && typeName.charAt(0) == '{' && typeName.charAt(length - 1) == '}';
    }

    private void processSuppressWarnings(JSDocTag tag, @NonNull CountingReporter reporter, IModelBuilder.IElement element) {
        boolean hasParenthesis;
        ANTLRStringStream input = new ANTLRStringStream(tag.value());
        boolean bl = hasParenthesis = input.LT(1) == 40;
        if (hasParenthesis) {
            input.consume();
        }
        while (true) {
            int ch;
            block14: {
                ch = input.LT(1);
                while (Character.isWhitespace(ch)) {
                    input.consume();
                    ch = input.LT(1);
                }
                if (ch == 34 || ch == 39) {
                    char quote = (char)ch;
                    input.consume();
                    int start = input.index();
                    while (true) {
                        if ((ch = input.LT(1)) == quote) {
                            this.suppressWarning(tag, reporter, element, (CharStream)input, start);
                            input.consume();
                            break block14;
                        }
                        if (ch == -1) {
                            reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "Closing " + quote + " expected", tag.start(), tag.end());
                            break block14;
                        }
                        input.consume();
                    }
                }
                int start = input.index();
                while (true) {
                    if ((ch = input.LT(1)) == 44 || ch == 41 || ch == -1 || Character.isWhitespace(ch)) {
                        this.suppressWarning(tag, reporter, element, (CharStream)input, start);
                        break;
                    }
                    input.consume();
                }
            }
            ch = input.LT(1);
            while (ch != -1 && Character.isWhitespace(ch)) {
                input.consume();
                ch = input.LT(1);
            }
            if (ch != 44) break;
            input.consume();
        }
        if (hasParenthesis) {
            if (input.LT(1) == 41) {
                input.consume();
            } else {
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "Closing ) expected", tag.start(), tag.end());
            }
        }
        if (reporter.problemCount != 0 && input.LT(1) != -1) {
            reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "Unexpected content", tag.start(), tag.end());
        }
    }

    private void suppressWarning(JSDocTag tag, @NonNull CountingReporter reporter, IModelBuilder.IElement element, CharStream input, int start) {
        String categoryId = input.substring(start, input.index() - 1);
        if (categoryId.length() != 0) {
            IProblemCategory category = this.getCategory(categoryId);
            if (category != null) {
                element.addSuppressedWarning(category);
            } else {
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, NLS.bind((String)"Unsupported {0}({1})", (Object)"@SuppressWarnings", (Object)categoryId), tag.start(), tag.end());
            }
        } else {
            reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "warning identifier expected", tag.start(), tag.end());
        }
    }

    protected IProblemCategory getCategory(String categoryId) {
        return ProblemCategoryManager.getInstance().getCategory("org.eclipse.dltk.javascript.core.nature", "@SuppressWarnings", categoryId);
    }

    public static ParameterNode parseParameter(JSDocTag tag) {
        int propertyIndex;
        TagTokenizer tokenizer = new TagTokenizer(tag);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        int typeOffset = -1;
        String type = null;
        String token = tokenizer.nextToken();
        if (JSDocSupport.isBraced(token)) {
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            typeOffset = tokenizer.getTokenStart();
            type = token;
            token = tokenizer.nextToken();
        }
        int tokenStart = tokenizer.getTokenStart();
        if (token.startsWith("[") && token.endsWith("]")) {
            token = token.substring(1, token.length() - 1);
            ++tokenStart;
            int separator = token.indexOf(61);
            if (separator != -1) {
                token = token.substring(0, separator);
            }
        }
        if ((propertyIndex = token.indexOf(46)) != -1) {
            token = token.substring(0, propertyIndex);
        }
        return new ParameterNode(type, typeOffset, token, tokenStart);
    }

    public static TypedElementNode parseOptionalType(JSDocTag tag) {
        TagTokenizer tokenizer = new TagTokenizer(tag);
        if (tokenizer.peekChar() == '{' && tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            return new TypedElementNode(type, tokenizer.getTokenStart());
        }
        return null;
    }

    public static TypeNode parseType(JSDocTag tag) {
        TagTokenizer tokenizer = new TagTokenizer(tag);
        if (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            return new TypeNode(type, tokenizer.getTokenStart(), JSDocSupport.isBraced(type));
        }
        return null;
    }

    private static class CountingReporter
    implements ProblemReporter {
        @Nullable
        final JSProblemReporter reporter;
        int problemCount;

        public CountingReporter(@Nullable JSProblemReporter reporter) {
            this.reporter = reporter;
        }

        public void reportProblem(IProblemIdentifier identifier, String message, int start, int end) {
            ++this.problemCount;
            if (this.reporter != null) {
                this.reporter.reportProblem(identifier, message, start, end);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JSDocFunctionContext {
        DECLARATION{

            String[] getReturnTags() {
                return JSDocTag.RETURN_TAGS;
            }
        }
        ,
        EXPRESSION{

            String[] getReturnTags() {
                return RETURN_ONLY_TAGS;
            }
        };

        static final String[] RETURN_ONLY_TAGS;

        static {
            RETURN_ONLY_TAGS = new String[]{"@returns", "@return"};
        }

        abstract String[] getReturnTags();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedValue<T> {
        public final String name;
        public final T value;

        private NamedValue(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public static <T> NamedValue<T> of(String name, T value) {
            return new NamedValue<T>(name, value);
        }
    }

    protected static class ParamInfo {
        public String type;
        public boolean varargs;
        public boolean optional;

        protected ParamInfo() {
        }

        void clear() {
            this.type = null;
            this.varargs = false;
            this.optional = false;
        }
    }

    public static class ParameterNode
    extends TypedElementNode {
        @NonNull
        public final String name;
        public final int offset;

        ParameterNode(String type, int typeOffset, String name, int offset) {
            super(type, typeOffset);
            this.name = name;
            this.offset = offset;
        }

        public boolean isInParameter(int position) {
            return this.offset <= position && this.offset + this.name.length() >= position;
        }
    }

    public static class TagTokenizer {
        private final String content;
        private final int end;
        private int position;
        private int tokenStart;
        private String current;

        public TagTokenizer(JSDocTag tag) {
            this(tag.value());
        }

        public TagTokenizer(String content) {
            this.content = content;
            this.end = content.length();
            this.position = this.skipDelimiters(0);
        }

        public boolean hasMoreTokens() {
            return this.current != null || this.position < this.end;
        }

        public char peekChar() {
            if (this.current == null) {
                if (this.position < this.end) {
                    return this.content.charAt(this.position);
                }
                return '\u0000';
            }
            if (this.current.length() != 0) {
                return this.current.charAt(0);
            }
            return '\u0000';
        }

        public String peek() {
            if (this.current == null) {
                if (this.position < this.end) {
                    this.current = this.fetchNextToken();
                } else {
                    return null;
                }
            }
            return this.current;
        }

        public String nextToken() {
            if (this.current != null) {
                String token = this.current;
                this.current = null;
                return token;
            }
            return this.fetchNextToken();
        }

        public int getTokenStart() {
            return this.tokenStart;
        }

        private int skipDelimiters(int pos) {
            while (pos < this.end && Character.isWhitespace(this.content.charAt(pos))) {
                ++pos;
            }
            return pos;
        }

        private String fetchNextToken() {
            if (this.position == this.end) {
                throw new NoSuchElementException();
            }
            this.tokenStart = this.position;
            int braceCount = 0;
            while (this.position < this.end) {
                if (Character.isWhitespace(this.content.charAt(this.position)) && braceCount == 0) break;
                if (this.content.charAt(this.position) == '{') {
                    ++braceCount;
                } else if (this.content.charAt(this.position) == '}') {
                    --braceCount;
                }
                ++this.position;
            }
            String token = this.content.substring(this.tokenStart, this.position);
            this.position = this.skipDelimiters(this.position);
            return token;
        }
    }

    public static class TypeNode
    extends TypedElementNode {
        private final boolean braced;

        boolean isBraced() {
            return this.braced;
        }

        TypeNode(String type, int typeOffset, boolean braced) {
            super(type, typeOffset);
            this.braced = braced;
        }
    }

    public static class TypedElementNode {
        @Nullable
        private final String type;
        private final int typeOffset;

        boolean isBraced() {
            return true;
        }

        TypedElementNode(String type, int typeOffset) {
            this.type = type;
            this.typeOffset = typeOffset;
        }

        @Nullable
        public String getTypeExpression() {
            if (this.type != null) {
                return this.isBraced() ? this.type.substring(1, this.type.length() - 1) : this.type;
            }
            return null;
        }

        public int getTypeExpressionStart() {
            return this.typeOffset >= 0 ? this.typeOffset + (this.isBraced() ? 1 : 0) : -1;
        }

        public boolean isInType(int position) {
            return this.type != null && (this.isBraced() ? this.typeOffset < position && position < this.typeOffset + this.type.length() : this.typeOffset <= position && position <= this.typeOffset + this.type.length());
        }
    }
}

