/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDialogAccess;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AccessRulesDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementSorter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathSupport;
import org.eclipse.dltk.internal.ui.wizards.buildpath.NewContainerDialog;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fBuildPathList;
    private IScriptProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDZIP = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_ADDLIB = 2;
    private final int IDX_ADDEXTFOL = 3;
    private final int IDX_EDIT = 5;
    private final int IDX_REMOVE = 6;
    private final int IDX_REPLACE = 8;
    private final int IDX_WITHOUTZIP = -2;
    private int IDX_ADD = 0;
    private boolean fWithZip = false;

    public LibrariesWorkbookPage(boolean supportZips, ListDialogField classPathList, IWorkbenchPreferenceContainer pageContainer) {
        String[] buttonLabelsWithout;
        this.fBuildPathList = classPathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[9];
        stringArray[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addzip_button;
        stringArray[1] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextzip_button;
        stringArray[2] = NewWizardMessages.LibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_add_external_source_folder_button;
        stringArray[5] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray[6] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        stringArray[8] = NewWizardMessages.LibrariesWorkbookPage_libraries_replace_button;
        String[] buttonLabelsWith = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray2[1] = NewWizardMessages.LibrariesWorkbookPage_libraries_add_external_source_folder_button;
        stringArray2[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray2[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        String[] buttonLabels = buttonLabelsWithout = stringArray2;
        this.IDX_ADD = -2;
        this.fWithZip = supportZips;
        if (this.fWithZip) {
            buttonLabels = buttonLabelsWith;
            this.IDX_ADD = 0;
        }
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new BPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        if (this.fWithZip) {
            this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        } else {
            this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_without_label);
        }
        this.fLibrariesList.enableButton(6 + this.IDX_ADD, false);
        this.fLibrariesList.enableButton(5 + this.IDX_ADD, false);
        if (this.fWithZip) {
            this.fLibrariesList.enableButton(8 + this.IDX_ADD, false);
        }
        this.fLibrariesList.setViewerSorter(new BPListElementSorter());
    }

    public void setTitle(String title) {
        this.fLibrariesList.setLabelText(title);
    }

    public void init(IScriptProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateLibrariesList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LibrariesWorkbookPage.this.updateLibrariesList();
                }
            });
        }
    }

    private void updateLibrariesList() {
        List cpelements = this.fBuildPathList.getElements();
        ArrayList<BPListElement> libelements = new ArrayList<BPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            BPListElement cpe = (BPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new BPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        IEnvironment environment = this.getEnvironment();
        switch (index - this.IDX_ADD) {
            case 0: {
                if (this.fWithZip) {
                    libentries = this.openZipFileDialog(null);
                    break;
                }
            }
            case 1: {
                if (this.fWithZip) {
                    libentries = this.openExtZipFileDialog(null, environment);
                    break;
                }
            }
            case 2: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 3: {
                libentries = this.opensExtSourceFolderDialog(null, environment);
                break;
            }
            case 5: {
                this.editEntry();
                return;
            }
            case 6: {
                this.removeEntry();
                return;
            }
            case 8: {
                this.replaceArchiveFile();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<BPListElement> elementsToAdd = new ArrayList<BPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                BPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            if (index == 2 + this.IDX_ADD) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    public void addElement(BPListElement element) {
        this.fLibrariesList.addElement(element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    private void askForAddingExclusionPatternsDialog(List newEntries) {
        HashSet modified = new HashSet();
        List existing = this.fBuildPathList.getElements();
        LibrariesWorkbookPage.fixNestingConflicts(newEntries.toArray(new BPListElement[newEntries.size()]), existing.toArray(new BPListElement[existing.size()]), modified);
        if (!modified.isEmpty()) {
            String title = NewWizardMessages.LibrariesWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void replaceArchiveFile() {
    }

    private IProjectFragment getSelectedProjectFragment() {
        List elements = this.fLibrariesList.getSelectedElements();
        if (elements.size() == 1) {
            Object object = elements.get(0);
            boolean cfr_ignored_0 = object instanceof BPListElement;
        }
        return null;
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        HashMap<BPListElement, HashSet<String>> containerEntriesToUpdate = new HashMap<BPListElement, HashSet<String>>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                String key = attrib.getKey();
                IAccessRule[] value = null;
                if (key.equals("accessrules")) {
                    value = new IAccessRule[]{};
                }
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof BPListElement) {
                    BPListElement containerEntry = attrib.getParent();
                    HashSet<String> changedAttributes = (HashSet<String>)containerEntriesToUpdate.get(containerEntry);
                    if (changedAttributes == null) {
                        changedAttributes = new HashSet<String>();
                        containerEntriesToUpdate.put(containerEntry, changedAttributes);
                    }
                    changedAttributes.add(key);
                }
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fBuildPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        for (Map.Entry entry : containerEntriesToUpdate.entrySet()) {
            BPListElement curr = (BPListElement)entry.getKey();
            HashSet attribs = (HashSet)entry.getValue();
            String[] changedAttributes = attribs.toArray(new String[attribs.size()]);
            IBuildpathEntry changedEntry = curr.getBuildpathEntry();
            this.updateContainerEntry(changedEntry, changedAttributes, this.fCurrJProject, ((BPListElement)curr.getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                if (attrib.isInNonModifiableContainer()) {
                    return false;
                }
                if (attrib.getKey().equals("accessrules")) {
                    return ((IAccessRule[])attrib.getValue()).length > 0;
                }
                if (attrib.getValue() == null) {
                    return false;
                }
            } else if (elem instanceof BPListElement) {
                BPListElement curr = (BPListElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((BPListElement)elem);
        } else if (elem instanceof BPListElementAttribute) {
            this.editAttributeEntry((BPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(BPListElementAttribute elem) {
        AccessRulesDialog dialog;
        int res;
        String key = elem.getKey();
        BPListElement selElement = elem.getParent();
        if (key.equals("accessrules") && ((res = (dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, this.fPageContainer != null)).open()) == 0 || res == 10)) {
            selElement.setAttribute("accessrules", dialog.getAccessRules());
            String[] changedAttributes = new String[]{"accessrules"};
            this.attributeUpdated(selElement, changedAttributes);
            this.fLibrariesList.refresh(elem);
            this.fBuildPathList.dialogFieldChanged();
            this.updateEnabledState();
            if (res == 10) {
                dialog.performPageSwitch(this.fPageContainer);
            }
        }
    }

    private void attributeUpdated(BPListElement selElement, String[] changedAttributes) {
        Object parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof BPListElement) {
            IBuildpathEntry updatedEntry = selElement.getBuildpathEntry();
            this.updateContainerEntry(updatedEntry, changedAttributes, this.fCurrJProject, ((BPListElement)parentContainer).getPath());
        }
    }

    private void updateContainerEntry(final IBuildpathEntry newEntry, final String[] changedAttributes, final IScriptProject jproject, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildPathSupport.modifyBuildpathEntry(null, newEntry, changedAttributes, jproject, containerPath, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(BPListElement elem) {
        BPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IEnvironment environment = this.getEnvironment();
                IResource resource = elem.getResource();
                if (resource == null) {
                    if (Util.isArchiveFileName((IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)elem.getScriptProject()), (String)elem.getPath().toOSString())) {
                        res = this.openExtZipFileDialog(elem, environment);
                        break;
                    }
                    res = this.opensExtSourceFolderDialog(elem, environment);
                    break;
                }
                if (resource.getType() == 2) {
                    if (resource.exists()) {
                        res = this.opensSourceFolderDialog(elem);
                        break;
                    }
                    res = this.openNewClassFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openZipFileDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            BPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement(elem, curr);
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(5 + this.IDX_ADD, this.canEdit(selElements));
        this.fLibrariesList.enableButton(6 + this.IDX_ADD, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        if (this.fWithZip) {
            this.fLibrariesList.enableButton(1 + this.IDX_ADD, noAttributes);
            this.fLibrariesList.enableButton(0 + this.IDX_ADD, noAttributes);
            this.fLibrariesList.enableButton(8 + this.IDX_ADD, this.getSelectedProjectFragment() != null);
        }
        this.fLibrariesList.enableButton(2 + this.IDX_ADD, noAttributes);
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof BPListElement) {
            BPListElement curr = (BPListElement)elem;
            return !(curr.getResource() instanceof IFolder) && !curr.isExternalFolder() && curr.getParentContainer() == null;
        }
        if (elem instanceof BPListElementAttribute) {
            BPListElementAttribute attrib = (BPListElementAttribute)elem;
            return !attrib.isInNonModifiableContainer();
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateBuildpathList();
        }
    }

    private void updateBuildpathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fBuildPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            BPListElement cpe = (BPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fBuildPathList.setElements(cpelements);
        }
    }

    private BPListElement[] openNewClassFolderDialog(BPListElement existing) {
        String title = existing == null ? NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_new_title : NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_edit_title;
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(Messages.format(NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_description, projpath.toString()));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new BPListElement[]{this.newBPLibraryElement((IResource)folder, false)};
        }
        return null;
    }

    private BPListElement[] opensExtSourceFolderDialog(BPListElement existing, IEnvironment environment) {
        IPath[] selected;
        if (existing == null && (selected = BuildpathDialogAccess.chooseExtSourceFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing), environment)) != null) {
            ArrayList<BPListElement> res = new ArrayList<BPListElement>();
            int i = 0;
            while (i < selected.length) {
                res.add(new BPListElement(this.fCurrJProject, 1, selected[i], null, true));
                ++i;
            }
            return res.toArray(new BPListElement[res.size()]);
        }
        return null;
    }

    private BPListElement[] opensSourceFolderDialog(BPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildpathDialogAccess.chooseSourceFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<BPListElement> res = new ArrayList<BPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newBPLibraryElement(resource, false));
                }
                ++i;
            }
            return res.toArray(new BPListElement[res.size()]);
        }
        return null;
    }

    private BPListElement[] openZipFileDialog(BPListElement existing) {
        IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
        if (existing == null) {
            IPath[] selected = BuildpathDialogAccess.chooseArchiveEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedArchiveFiles(existing));
            if (selected != null) {
                ArrayList<BPListElement> res = new ArrayList<BPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = root.findMember(curr);
                    if (resource instanceof IFile) {
                        res.add(this.newBPLibraryElement(resource, false));
                    }
                    ++i;
                }
                return res.toArray(new BPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildpathDialogAccess.configureArchiveEntry(this.getShell(), existing.getPath(), this.getUsedArchiveFiles(existing));
            if (configured != null && (resource = root.findMember(configured)) instanceof IFile) {
                return new BPListElement[]{this.newBPLibraryElement(resource, false)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(BPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            BPListElement elem = (BPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedArchiveFiles(BPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            BPListElement elem = (BPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private BPListElement newBPLibraryElement(IResource res, boolean external) {
        return new BPListElement(this.fCurrJProject, 1, res.getFullPath(), res, external);
    }

    private BPListElement[] openExtZipFileDialog(BPListElement existing, IEnvironment environment) {
        if (existing == null) {
            IPath[] selected = BuildpathDialogAccess.chooseExternalArchiveEntries(this.getShell(), environment);
            if (selected != null) {
                ArrayList<BPListElement> res = new ArrayList<BPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new BPListElement(this.fCurrJProject, 1, selected[i], null, true));
                    ++i;
                }
                return res.toArray(new BPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildpathDialogAccess.configureExternalArchiveEntry(this.getShell(), existing.getPath());
            if (configured != null) {
                return new BPListElement[]{new BPListElement(this.fCurrJProject, 1, configured, null, true)};
            }
        }
        return null;
    }

    private BPListElement[] openContainerSelectionDialog(BPListElement existing) {
        if (existing == null) {
            IBuildpathEntry[] created = BuildpathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawBuildpath());
            if (created != null) {
                BPListElement[] res = new BPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new BPListElement(this.fCurrJProject, 5, created[i].getPath(), null, false);
                    ++i;
                }
                return res;
            }
        } else {
            IBuildpathEntry created = BuildpathDialogAccess.configureContainerEntry(this.getShell(), existing.getBuildpathEntry(), this.fCurrJProject, this.getRawBuildpath());
            if (created != null) {
                BPListElement elem = BPListElement.createFromExisting(created, this.fCurrJProject);
                return new BPListElement[]{elem};
            }
        }
        return null;
    }

    private IBuildpathEntry[] getRawBuildpath() {
        IBuildpathEntry[] currEntries = new IBuildpathEntry[this.fBuildPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            BPListElement curr = (BPListElement)this.fBuildPathList.getElement(i);
            currEntries[i] = curr.getBuildpathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    private IEnvironment getEnvironment() {
        return EnvironmentManager.getEnvironment((IModelElement)this.fCurrJProject);
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            BPListElementAttribute attribute;
            if (element instanceof BPListElement) {
                return ((BPListElement)element).getChildren();
            }
            if (element instanceof BPListElementAttribute && "accessrules".equals((attribute = (BPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof BPListElementAttribute) {
                return ((BPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

