/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IModelElementVisitorExtension;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.FieldDeclarationMatch;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.LocalVariableDeclarationMatch;
import org.eclipse.dltk.core.search.LocalVariableReferenceMatch;
import org.eclipse.dltk.core.search.MethodDeclarationMatch;
import org.eclipse.dltk.core.search.MethodReferenceMatch;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.matching.IMatchLocator;
import org.eclipse.dltk.core.search.matching.ModuleFactory;
import org.eclipse.dltk.core.search.matching2.IMatchingNodeSet;
import org.eclipse.dltk.core.search.matching2.IMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.core.search.matching2.MatchingCollector;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureReporter2;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.internal.search.ArgumentDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.JavaScriptMatchingNodeSet;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingCollectorSourceElementRequestor;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MatchingPredicateFactory;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;

public class JavaScriptMatchLocator
implements IMatchLocator,
IModelElementVisitor,
IModelElementVisitorExtension {
    private IProgressMonitor progressMonitor;
    private SearchRequestor requestor;
    private IDLTKSearchScope scope;
    private SearchPattern pattern;
    private JavaScriptMatchingNodeSet nodeSet = new JavaScriptMatchingNodeSet();
    private SearchParticipant participant;

    public void initialize(SearchPattern pattern, IDLTKSearchScope scope) {
        this.pattern = pattern;
        this.scope = scope;
    }

    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        Assert.isNotNull((Object)this.requestor);
        ModuleFactory moduleFactory = new ModuleFactory(this.scope);
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        IMatchingPredicate<MatchingNode> predicate = MatchingPredicateFactory.create(inferencer2, this.pattern);
        if (predicate == null) {
            return;
        }
        MatchingCollectorSourceElementRequestor matchingCollectorRequestor = new MatchingCollectorSourceElementRequestor((MatchingCollector<MatchingNode>)new MatchingCollector(predicate, (IMatchingNodeSet)this.nodeSet));
        StructureReporter2 visitor = new StructureReporter2(inferencer2, matchingCollectorRequestor);
        SearchDocument[] searchDocumentArray = searchDocuments;
        int n = searchDocuments.length;
        int n2 = 0;
        while (n2 < n) {
            SearchDocument document = searchDocumentArray[n2];
            ISourceModule module = moduleFactory.create(document);
            if (module != null) {
                this.nodeSet.clear();
                inferencer2.setModelElement((IModelElement)module);
                Script script = JavaScriptParserUtil.parse((ISourceModule)module);
                inferencer2.setVisitor(visitor);
                inferencer2.doInferencing(script);
                matchingCollectorRequestor.report();
                if (!this.nodeSet.isEmpty()) {
                    this.resolvePotentialMatches(this.nodeSet);
                    this.participant = document.getParticipant();
                    module.accept((IModelElementVisitor)this);
                }
                for (MatchingNode matchingNode : this.nodeSet.matchingNodes()) {
                    this.report(matchingNode, (IModelElement)module);
                }
            }
            ++n2;
        }
    }

    private void resolvePotentialMatches(JavaScriptMatchingNodeSet nodeSet) {
        for (MatchingNode node : nodeSet.getPossibleMatchingNodes()) {
            nodeSet.addMatch(node, MatchLevel.ACCURATE_MATCH);
        }
        nodeSet.clearPossibleMatchingNodes();
        if (BasicSearchEngine.VERBOSE) {
            System.out.print("\t- node set: accurate=" + nodeSet.countMatchingNodes() + ", possible=" + nodeSet.countPossibleMatchingNodes());
        }
    }

    public boolean visit(IModelElement element) {
        return element instanceof ISourceModule || element instanceof IMember;
    }

    public void endVisit(IModelElement element) {
        if (!(element instanceof IMember)) {
            return;
        }
        try {
            ISourceRange range = ((ISourceReference)element).getSourceRange();
            List matchingNodes = this.nodeSet.matchingNodes(range.getOffset(), range.getOffset() + range.getLength());
            for (MatchingNode node : matchingNodes) {
                this.nodeSet.removeTrustedMatch(node);
                this.report(node, element);
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.error(e);
        }
    }

    protected void report(MatchingNode node, IModelElement element) throws CoreException {
        if (node instanceof FieldDeclarationNode) {
            this.requestor.acceptSearchMatch((SearchMatch)new FieldDeclarationMatch(element, 0, node.sourceStart(), JavaScriptMatchLocator.length(node), this.participant, element.getResource()));
        } else if (node instanceof FieldReferenceNode) {
            this.requestor.acceptSearchMatch((SearchMatch)new FieldReferenceMatch(element, ((FieldReferenceNode)node).node, 0, node.sourceStart(), JavaScriptMatchLocator.length(node), true, true, false, this.participant, element.getResource()));
        } else if (node instanceof MethodDeclarationNode) {
            this.requestor.acceptSearchMatch((SearchMatch)new MethodDeclarationMatch(element, 0, node.sourceStart(), JavaScriptMatchLocator.length(node), this.participant, element.getResource()));
        } else if (node instanceof MethodReferenceNode) {
            this.requestor.acceptSearchMatch((SearchMatch)new MethodReferenceMatch(element, 0, node.sourceStart(), JavaScriptMatchLocator.length(node), false, this.participant, element.getResource()));
        } else if (node instanceof LocalVariableDeclarationNode || node instanceof ArgumentDeclarationNode) {
            this.requestor.acceptSearchMatch((SearchMatch)new LocalVariableDeclarationMatch(element, 0, node.sourceStart(), JavaScriptMatchLocator.length(node), this.participant, element.getResource()));
        } else if (node instanceof LocalVariableReferenceNode) {
            this.requestor.acceptSearchMatch((SearchMatch)new LocalVariableReferenceMatch(element, 0, node.sourceStart(), JavaScriptMatchLocator.length(node), true, true, false, this.participant, element.getResource()));
        } else {
            throw new IllegalArgumentException(String.valueOf(node.getClass().getName()) + " support not implemented");
        }
    }

    private static int length(MatchingNode node) {
        return node.sourceEnd() - node.sourceStart();
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setRequestor(SearchRequestor requestor) {
        this.requestor = requestor;
    }
}

