/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

public class FlowStatus {
    boolean isBreak;
    boolean returnThrow;
    boolean returnValue;
    boolean returnWithoutValue;
    boolean noReturn;

    public void add(FlowStatus value) {
        if (value != null) {
            this.isBreak |= value.isBreak;
            this.returnThrow |= value.returnThrow;
            this.returnValue |= value.returnValue;
            this.returnWithoutValue |= value.returnWithoutValue;
            this.noReturn = value.noReturn || !value.isAnyReturn();
        } else {
            this.noReturn = true;
        }
    }

    public void addCase(FlowStatus value) {
        if (value != null) {
            this.isBreak |= value.isBreak;
            this.returnThrow |= value.returnThrow;
            this.returnValue |= value.returnValue;
            this.returnWithoutValue |= value.returnWithoutValue;
        }
    }

    public boolean isTerminated() {
        return this.isBreak || this.isReturned();
    }

    public boolean isAnyReturn() {
        return this.returnThrow || this.returnValue || this.returnWithoutValue;
    }

    public boolean isReturned() {
        return this.isAnyReturn() && !this.noReturn;
    }

    public void addBranch(FlowStatus branch) {
        if (branch != null) {
            if (this.noReturn != branch.noReturn) {
                this.noReturn = true;
            }
            if (this.returnValue != branch.returnValue) {
                this.returnValue = true;
            }
            if (this.returnWithoutValue != branch.returnWithoutValue) {
                this.returnWithoutValue = true;
            }
        } else {
            this.noReturn = true;
        }
    }
}

