/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceMethodUtils;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.IProposalHolder;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardSelfCompletingReference
implements IReference,
SelfCompletingReference {
    private String name;
    private final boolean childIsh;
    boolean fRef;
    boolean local;
    private IReferenceLocation location;
    private Map<String, IReference> childs;
    private String[] parameterNames;
    private String proposalInfo;
    protected StandardSelfCompletingReference parentRef;
    private URL imageUrl;
    private String returnType;
    private int parameterIndex = -1;

    public StandardSelfCompletingReference(String paramOrVarName, boolean childIsh) {
        this.name = paramOrVarName;
        this.childIsh = childIsh;
    }

    public IReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocationInformation(IReferenceLocation location) {
        this.location = location;
    }

    @Override
    public Set<IReference> getChilds(boolean resolveLocals) {
        if (this.childs == null) {
            this.childs = new HashMap<String, IReference>(3);
            this.createChilds();
        }
        return new HashSet<IReference>(this.childs.values());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getTypes() {
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String getParentName() {
        return this.name;
    }

    @Override
    public IReference getChild(String key, boolean resolveLocals) {
        if (this.childs == null) {
            this.childs = new HashMap<String, IReference>(3);
            this.createChilds();
        }
        return this.childs.get(key);
    }

    protected void createChilds() {
    }

    @Override
    public void setChild(String key, IReference ref) {
        if (this.childs == null) {
            this.childs = new HashMap<String, IReference>(3);
            this.createChilds();
        }
        ref = this.testRecursion(ref);
        this.childs.put(key, ref);
    }

    protected void addChildren(Collection<IReference> references) {
        for (IReference reference : references) {
            this.setChild(reference.getName(), reference);
        }
    }

    private IReference testRecursion(IReference ref) {
        if (ref instanceof StandardSelfCompletingReference) {
            StandardSelfCompletingReference ssr = (StandardSelfCompletingReference)ref;
            ssr.parentRef = this;
            if (this.parentRef != null) {
                HashSet<IReference> set = new HashSet<IReference>();
                set.add(this.parentRef);
                IReference child = this.parentRef.findEqualParent(ref, set);
                if (child != null) {
                    ref = child;
                }
            }
        }
        return ref;
    }

    private IReference findEqualParent(IReference ref, Set<IReference> parents) {
        if (this.equals(ref)) {
            return this;
        }
        if (this.parentRef != null && !parents.contains(this.parentRef)) {
            parents.add(this.parentRef);
            return this.parentRef.findEqualParent(ref, parents);
        }
        return null;
    }

    @Override
    public boolean isChildishReference() {
        return this.childIsh;
    }

    @Override
    public void recordDelete(String fieldId) {
        if (this.childs == null) {
            return;
        }
        this.childs.remove(fieldId);
    }

    @Override
    public IReference getPrototype(boolean resolveLocals) {
        return this.getChild("prototype", true);
    }

    @Override
    public void setPrototype(IReference ref) {
        this.setChild("prototype", ref);
    }

    @Override
    public void addModelElements(Collection<IModelElement> toAdd) {
        if (this.location != null) {
            if (this.isFunctionRef()) {
                MethodReference method = new MethodReference((ModelElement)this.location.getModelElement(), this.name, this.getParameters(), this.getProposalInfo(), this.getReturnType());
                toAdd.add((IModelElement)method);
            } else {
                FakeField fakeField = new FakeField((ModelElement)this.location.getModelElement(), this.name, this.location.getOffset(), this.location.getLength(), this.getReturnType());
                fakeField.setProposalInfo(this.getProposalInfo());
                toAdd.add((IModelElement)fakeField);
            }
        }
    }

    @Override
    public boolean isFunctionRef() {
        return this.fRef;
    }

    public StandardSelfCompletingReference setFunctionRef() {
        this.fRef = true;
        return this;
    }

    private IParameter[] getParameters() {
        if (this.parameterNames == null || this.parameterNames.length == 0) {
            return SourceMethodUtils.NO_PARAMETERS;
        }
        IParameter[] params = new Param[this.parameterNames.length];
        int i = 0;
        while (i < this.parameterNames.length) {
            params[i] = new Param(this.parameterNames[i]);
            ++i;
        }
        return params;
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(String[] parameterNames) {
        this.parameterNames = parameterNames;
    }

    @Override
    public String getProposalInfo() {
        return this.proposalInfo;
    }

    @Override
    public URL getImageURL() {
        return this.imageUrl;
    }

    public void setImageUrl(URL imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setProposalInfo(String proposalInfo) {
        this.proposalInfo = proposalInfo;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StandardSelfCompletingReference) {
            StandardSelfCompletingReference ur = (StandardSelfCompletingReference)obj;
            return ur.name.equals(this.name) && this.fRef == ur.fRef && this.childIsh == ur.childIsh && this.fRef == ur.fRef && this.local == ur.local && StandardSelfCompletingReference.equals(this.location, ur.location);
        }
        return false;
    }

    private static boolean equals(IReferenceLocation ref1, IReferenceLocation ref2) {
        if (ref1 != null && ref2 != null) {
            return ref1.getOffset() == ref2.getOffset() && ref1.getLength() == ref2.getLength();
        }
        return ref1 == null && ref2 == null;
    }

    @Override
    public int getKind() {
        return this.isFunctionRef() ? 5 : 4;
    }

    public void setParameterIndex(int index) {
        this.parameterIndex = index;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    private static class MethodReference
    extends SourceMethod
    implements IProposalHolder {
        private final IParameter[] parameters;
        private final String proposalInfo;
        private final String type;

        public MethodReference(ModelElement parent, String name, IParameter[] parameters, String proposalInfo, String type) {
            super(parent, name);
            this.parameters = parameters;
            this.proposalInfo = proposalInfo;
            this.type = type;
        }

        public String[] getParameterNames() throws ModelException {
            return SourceMethodUtils.getParameterNames((IParameter[])this.parameters);
        }

        public String getProposalInfo() {
            return this.proposalInfo;
        }

        public IParameter[] getParameters() throws ModelException {
            return this.parameters;
        }

        public String getType() throws ModelException {
            return this.type;
        }

        public boolean exists() {
            return true;
        }

        public boolean isConstructor() throws ModelException {
            return false;
        }
    }

    private static final class Param
    implements IParameter {
        private final String name;

        public Param(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return null;
        }

        public String getDefaultValue() {
            return null;
        }
    }
}

