/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.ILazyValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValue2;
import org.eclipse.dltk.internal.javascript.ti.PhantomValue;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableValue
implements IValue,
IValue2 {
    private Map<String, IValue> elementValues;
    protected IRType declaredType;
    protected final JSTypeSet types;
    protected Set<String> deletedChildren;
    protected ReferenceKind kind = ReferenceKind.UNKNOWN;
    protected ReferenceLocation location = ReferenceLocation.UNKNOWN;
    protected final Map<String, ImmutableValue> children;
    protected final Map<String, IValue> inherited;
    protected final Set<IValue> references;
    protected Map<String, Object> attributes;
    private static final Handler<JSTypeSet> GET_TYPES = new Handler<JSTypeSet>(){

        @Override
        public void process(ImmutableValue value, JSTypeSet result) {
            result.addAll(value.types);
        }
    };
    private static final Handler<JSTypeSet> GET_DECLARED_TYPES = new Handler<JSTypeSet>(){

        @Override
        public void process(ImmutableValue value, JSTypeSet result) {
            if (value.declaredType != null) {
                result.add(value.declaredType);
            }
        }
    };
    private static final Handler<Set<String>> GET_DIRECT_CHILDREN = new Handler<Set<String>>(){

        @Override
        public void process(ImmutableValue value, Set<String> result) {
            result.addAll(value.children.keySet());
        }
    };

    protected ImmutableValue() {
        this.types = JSTypeSet.create();
        this.children = new HashMap<String, ImmutableValue>(4, 0.9f);
        this.inherited = new HashMap<String, IValue>(4, 0.9f);
        this.references = new HashSet<IValue>(4, 0.9f);
    }

    public ImmutableValue(IRType declaredType, JSTypeSet types, Set<String> deletedChildren, ReferenceKind kind, ReferenceLocation location, Map<String, ImmutableValue> children, Map<String, IValue> inherited, Set<IValue> references, Map<String, Object> attributes) {
        this.declaredType = declaredType;
        this.types = types;
        this.deletedChildren = deletedChildren;
        this.kind = kind;
        this.location = location;
        this.children = children;
        this.inherited = inherited;
        this.references = references;
        this.attributes = attributes;
    }

    protected final boolean hasReferences() {
        return !this.references.isEmpty();
    }

    @Override
    public Set<? extends IValue> getReferences() {
        return this.references;
    }

    protected static <R> void execute(ImmutableValue value, Handler<R> handler, R result, Set<IValue> visited) {
        if (visited.add(value)) {
            if (value instanceof ILazyValue) {
                ((ILazyValue)((Object)value)).resolve();
            }
            handler.process(value, result);
            for (IValue child : value.references) {
                if (child instanceof ImmutableValue) {
                    ImmutableValue.execute((ImmutableValue)child, handler, result, visited);
                    continue;
                }
                if (!(handler instanceof Handler2)) continue;
                ((Handler2)handler).processOther(child, result);
            }
        }
    }

    @Override
    public JSTypeSet getTypes() {
        if (this.hasReferences()) {
            JSTypeSet result = JSTypeSet.create();
            ImmutableValue.execute(this, GET_TYPES, result, new HashSet<IValue>());
            return result;
        }
        return this.types;
    }

    @Override
    public IRType getDeclaredType() {
        if (this.declaredType != null) {
            return this.declaredType;
        }
        if (this.hasReferences()) {
            JSTypeSet result = JSTypeSet.create();
            ImmutableValue.execute(this, GET_DECLARED_TYPES, result, new HashSet<IValue>());
            return !result.isEmpty() ? result.getFirst() : null;
        }
        return null;
    }

    @Override
    public JSTypeSet getDeclaredTypes() {
        if (this.declaredType != null) {
            return JSTypeSet.singleton(this.declaredType);
        }
        if (this.hasReferences()) {
            JSTypeSet result = JSTypeSet.create();
            ImmutableValue.execute(this, GET_DECLARED_TYPES, result, new HashSet<IValue>());
            return result;
        }
        return JSTypeSet.emptySet();
    }

    @Override
    public ReferenceKind getKind() {
        return this.kind;
    }

    @Override
    public ReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public final Object getAttribute(String key) {
        return this.getAttribute(key, false);
    }

    @Override
    public Object getAttribute(String key, boolean includeReferences) {
        Object attribute = null;
        if (this.attributes != null) {
            attribute = this.attributes.get(key);
        }
        if (includeReferences && attribute == null && !this.references.isEmpty()) {
            attribute = this.visitReferenceForAttribute(key, new HashSet<ImmutableValue>());
        }
        return attribute;
    }

    private Object visitReferenceForAttribute(String key, Set<ImmutableValue> visited) {
        if (visited.add(this)) {
            for (IValue reference : this.references) {
                Object attribute = reference.getAttribute(key, false);
                if (attribute != null) {
                    return attribute;
                }
                if (!(reference instanceof ImmutableValue) || (attribute = ((ImmutableValue)reference).visitReferenceForAttribute(key, visited)) == null) continue;
                return attribute;
            }
        }
        return null;
    }

    @Override
    public Set<String> getDirectChildren() {
        if (this.hasReferences()) {
            HashSet<String> result = new HashSet<String>();
            ImmutableValue.execute(this, GET_DIRECT_CHILDREN, result, new HashSet<IValue>());
            return result;
        }
        return this.children.keySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        if (this.deletedChildren != null) {
            return this.deletedChildren;
        }
        return Collections.emptySet();
    }

    protected IValue findMember(String name, boolean resolve) {
        IValue value = null;
        if (this.elementValues != null) {
            value = this.elementValues.get(name);
        }
        if (!(value != null || this.declaredType == null && this.types.isEmpty())) {
            ITypeSystem typeSystem = this.getTypeSystem();
            if (this.declaredType != null && (value = ElementValue.findMemberA(typeSystem, this.declaredType, name)) != null) {
                if (this.elementValues == null) {
                    this.elementValues = new HashMap<String, IValue>(4, 0.9f);
                }
                this.elementValues.put(name, value);
                return value;
            }
            for (IRType type : this.types) {
                value = ElementValue.findMemberA(typeSystem, type, name);
                if (value == null) continue;
                if (this.elementValues == null) {
                    this.elementValues = new HashMap<String, IValue>(4, 0.9f);
                }
                this.elementValues.put(name, value);
                return value;
            }
        }
        return value;
    }

    @Override
    public IValue getChild(String name, boolean resolve) {
        if (this.hasReferences()) {
            HashSet result = new HashSet();
            ImmutableValue.execute(this, new GetChildHandler(name), result, new HashSet<IValue>());
            if (!result.isEmpty()) {
                return (IValue)result.iterator().next();
            }
            return this.findMember(name, resolve);
        }
        IValue child = this.children.get(name);
        if (child == null && (child = this.inherited.get(name)) == null) {
            child = this.findMember(name, resolve);
        }
        return child;
    }

    @Override
    public boolean hasChild(String name) {
        return this.children.containsKey(name) || this.inherited.containsKey(name);
    }

    @Override
    public IValue createChild(String name, int flags) {
        return null;
    }

    protected void childCreated(String name) {
        if (this.elementValues != null) {
            this.elementValues.remove(name);
        }
    }

    protected ITypeSystem getTypeSystem() {
        return TypeInferencer2.DELEGATING_TYPE_SYSTEM;
    }

    @Override
    public void setDeclaredType(IRType declaredType) {
    }

    @Override
    public void addType(IRType type) {
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public void setKind(ReferenceKind kind) {
    }

    @Override
    public void setLocation(ReferenceLocation location) {
    }

    @Override
    public void addValue(IValue src) {
    }

    @Override
    public void addReference(IValue src) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void putChild(String name, IValue value) {
    }

    @Override
    public void deleteChild(String name) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GetChildHandler
    implements Handler2<Set<IValue>> {
        private final String childName;

        public GetChildHandler(String childName) {
            this.childName = childName;
        }

        @Override
        public void process(ImmutableValue value, Set<IValue> result) {
            ImmutableValue child = value.children.get(this.childName);
            if (child != null) {
                result.add(child);
            } else {
                ITypeSystem typeSystem = value.getTypeSystem();
                ElementValue member = ElementValue.findMember(typeSystem, value.declaredType, this.childName);
                if (member != null) {
                    result.add(member);
                }
                JSTypeSet valueTypes = value.hasReferences() ? value.types : value.getTypes();
                for (IRType type : valueTypes) {
                    member = ElementValue.findMember(typeSystem, type, this.childName);
                    if (member == null) continue;
                    result.add(member);
                }
            }
        }

        @Override
        public void processOther(IValue value, Set<IValue> result) {
            if (value == PhantomValue.VALUE) {
                result.add(value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Handler<R> {
        public void process(ImmutableValue var1, R var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Handler2<R>
    extends Handler<R> {
        public void processOther(IValue var1, R var2);
    }
}

