/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.IXMLExpression;
import org.eclipse.dltk.javascript.ast.Identifier;

public class XmlAttributeIdentifier
extends Expression
implements IXMLExpression {
    private Expression expression;

    public XmlAttributeIdentifier(ASTNode parent) {
        super(parent);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toSourceString(String indentationString) {
        if (this.expression != null) {
            return "@" + this.expression.toSourceString(indentationString);
        }
        return "@?";
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.expression != null) {
                this.expression.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public String getAttributeName() {
        if (this.expression instanceof Identifier) {
            return String.valueOf('@') + ((Identifier)this.expression).getName();
        }
        return null;
    }
}

