/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.model.LocalVariable;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.ReferenceLocation;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SimpleType;
import org.eclipse.dltk.javascript.internal.core.codeassist.NodeFinder;
import org.eclipse.dltk.javascript.internal.core.codeassist.SelectionVisitor;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.typeinfo.IElementConverter;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptSelectionEngine2
extends ScriptSelectionEngine {
    private static final boolean DEBUG = false;

    public IModelElement[] select(IModuleSource module, int position, int i) {
        if (!(module.getModelElement() instanceof ISourceModule)) {
            return null;
        }
        String content = module.getSourceContents();
        if (position < 0 || position > content.length()) {
            return null;
        }
        NodeFinder finder = new NodeFinder(content, position);
        Script script = new JavaScriptParser().parse(module, null);
        ASTNode node = finder.locateNode(script);
        if (node != null && (node instanceof Identifier || node instanceof SimpleType)) {
            Set<Type> types;
            TypeInferencer2 inferencer2 = new TypeInferencer2();
            SelectionVisitor visitor = new SelectionVisitor(inferencer2, node);
            inferencer2.setVisitor(visitor);
            inferencer2.setModelElement(module.getModelElement());
            inferencer2.doInferencing(script);
            IValueReference value = visitor.getValue();
            if (value == null) {
                return null;
            }
            ReferenceKind kind = value.getKind();
            ISourceModule m = (ISourceModule)module.getModelElement();
            if (kind == ReferenceKind.ARGUMENT || kind == ReferenceKind.LOCAL) {
                ReferenceLocation location = value.getLocation();
                if (location == ReferenceLocation.UNKNOWN) {
                    return null;
                }
                return new IModelElement[]{new LocalVariable(module.getModelElement(), value.getName(), location.getDeclarationStart(), location.getDeclarationEnd(), location.getNameStart(), location.getNameEnd() - 1, null)};
            }
            if (kind == ReferenceKind.FUNCTION) {
                ReferenceLocation location = value.getLocation();
                if (location == ReferenceLocation.UNKNOWN) {
                    return null;
                }
                try {
                    m.reconcile(false, null, null);
                    m.accept((IModelElementVisitor)new Visitor(location.getNameStart(), location.getNameEnd()));
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                catch (ModelElementFound e) {
                    return new IModelElement[]{e.element};
                }
            } else if (kind == ReferenceKind.METHOD || kind == ReferenceKind.PROPERTY) {
                Collection members = JavaScriptValidations.extractElements(value, Member.class);
                if (members != null) {
                    return this.convert(m, members);
                }
            } else if (kind == ReferenceKind.TYPE && (types = value.getTypes()) != null) {
                return this.convert(m, types);
            }
        }
        return null;
    }

    private IModelElement[] convert(ISourceModule module, Collection<? extends Element> elements) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        for (Element element : elements) {
            try {
                IModelElement me = this.convert(module, element);
                if (me == null) continue;
                result.add(me);
            }
            catch (ModelException modelException) {}
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private IModelElement convert(ISourceModule module, Element element) throws ModelException {
        Type type = element instanceof Type ? (Type)element : ((Member)element).getDeclaringType();
        if (type != null && type.getKind() == TypeKind.PREDEFINED) {
            ArrayList<String> path = new ArrayList<String>();
            path.add(type.getName());
            if (element != type) {
                path.add(element.getName());
            }
            return this.resolveBuiltin(module.getScriptProject(), path);
        }
        IElementConverter[] iElementConverterArray = TypeInfoManager.getElementConverters();
        int n = iElementConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementConverter converter = iElementConverterArray[n2];
            IModelElement result = converter.convert(module, element);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private IModelElement resolveBuiltin(IScriptProject project, List<String> segments) throws ModelException {
        IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
        int n = iProjectFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment fragment = iProjectFragmentArray[n2];
            if (fragment.isBuiltin()) {
                ISourceModule m = fragment.getScriptFolder((IPath)Path.EMPTY).getSourceModule("builtins.js");
                if (!m.exists()) {
                    return null;
                }
                ISourceModule me = m;
                block1: for (String segment : segments) {
                    if (me instanceof IParent) {
                        IModelElement[] children;
                        IModelElement[] iModelElementArray = children = ((IParent)me).getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement child = iModelElementArray[n4];
                            if (segment.equals(child.getElementName())) {
                                me = child;
                                continue block1;
                            }
                            ++n4;
                        }
                    }
                    return null;
                }
                return me;
            }
            ++n2;
        }
        return null;
    }

    private static class ModelElementFound
    extends RuntimeException {
        private final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }

    private static class Visitor
    implements IModelElementVisitor {
        private final int nameStart;
        private final int nameEnd;

        public Visitor(int nameStart, int nameEnd) {
            this.nameStart = nameStart;
            this.nameEnd = nameEnd;
        }

        public boolean visit(IModelElement element) {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                try {
                    ISourceRange range = member.getNameRange();
                    if (range.getOffset() == this.nameStart && range.getLength() == this.nameEnd - this.nameStart) {
                        throw new ModelElementFound(element);
                    }
                }
                catch (ModelException modelException) {}
            }
            return true;
        }
    }
}

