/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.core.search.matching.PossibleMatch;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptModuleDeclaration;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptSourceParser;
import org.eclipse.dltk.internal.javascript.typeinference.ContextReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.VaribleDeclarationReference;
import org.eclipse.dltk.javascript.core.FunctionDeclarationReference;

public class JavaScriptMatchLocatorParser
extends MatchLocatorParser
implements IMatchLocatorParser {
    private JavaScriptSourceParser parser;
    IModelElement parent;

    public JavaScriptMatchLocatorParser(MatchLocator locator) {
        super(locator);
    }

    public ModuleDeclaration parse(PossibleMatch possibleMatch) {
        this.parent = possibleMatch.getModelElement();
        this.parser = new JavaScriptSourceParser(this.parent);
        return this.parser.parse((IModuleSource)possibleMatch, null);
    }

    public void parseBodies(ModuleDeclaration unit) {
        FieldDeclaration[] vars;
        JavaScriptModuleDeclaration md = (JavaScriptModuleDeclaration)unit;
        unit.rebuild();
        MethodDeclaration[] methods = unit.getFunctions();
        if (methods != null) {
            PatternLocator locator = this.getPatternLocator();
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = method;
                    locator.match(this.processMethod(methodDeclaration), this.getNodeSet());
                }
                ++i;
            }
        }
        if ((vars = md.getVariables()) != null) {
            PatternLocator locator = this.getPatternLocator();
            int i = 0;
            while (i < vars.length) {
                FieldDeclaration var = vars[i];
                locator.match(var, this.getNodeSet());
                ++i;
            }
        }
        HostCollection collection = md.getCollection();
        Collection<IReference> sm = collection.getReferences().values();
        Iterator<IReference> i = sm.iterator();
        HashSet hs = new HashSet();
        while (i.hasNext()) {
            IReference next = i.next();
            if (!(next instanceof IReference)) continue;
            IReference ref = next;
            this.reportRef(ref, null, 0, hs);
        }
        Map ms = md.getFunctionMap();
        Iterator<Object> ia = ms.values().iterator();
        PatternLocator locator = this.getPatternLocator();
        while (ia.hasNext()) {
            HostCollection next = (HostCollection)ia.next();
            FunctionDeclarationReference node = new FunctionDeclarationReference(0, 0, "!!!" + next.getName(), next);
            locator.match((Reference)node, this.getNodeSet());
        }
        Collection references = md.getReferences();
        for (SimpleReference r : references) {
            locator.match((Reference)r, this.getNodeSet());
        }
    }

    private void reportRef(IReference ref, String sma, int level, HashSet recursive) {
        String key = ref.getName();
        if (sma != null) {
            key = String.valueOf(sma) + '.' + key;
        }
        if (!(ref instanceof ContextReference)) {
            Set<IReference> sm = ref.getChilds(false);
            for (IReference next : sm) {
                IReference refa;
                if (!(next instanceof IReference) || recursive.contains(refa = next)) continue;
                recursive.add(refa);
                this.reportRef(refa, key, level + 1, recursive);
            }
        }
        PatternLocator locator = this.getPatternLocator();
        VaribleDeclarationReference node = new VaribleDeclarationReference(0, 0, key, ref);
        locator.match((Reference)node, this.getNodeSet());
    }
}

