/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransparentRef
implements IReference {
    private final TypeInferencer typeInferencer;
    IReference evaluateReference;
    private final String fieldId;
    private final Node node;
    ReferenceResolverContext cs;
    private boolean recursive = false;
    private IReferenceLocation location;

    TransparentRef(TypeInferencer typeInferencer, IReference evaluateReference, Node objID, String fieldId, IModelElement parent, ReferenceResolverContext cs) {
        this.typeInferencer = typeInferencer;
        this.evaluateReference = evaluateReference;
        this.fieldId = fieldId;
        this.node = objID;
        this.location = new ReferenceLocation(parent, 0, 0);
        this.cs = cs;
    }

    @Override
    public IReference getChild(String key, boolean resolveLocals) {
        if (this.recursive) {
            return null;
        }
        try {
            IReference child;
            this.recursive = true;
            IReference iReference = child = this.evaluateReference.getChild(key, resolveLocals);
            return iReference;
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public Set<IReference> getChilds(boolean resolveLocals) {
        if (this.recursive) {
            return Collections.emptySet();
        }
        try {
            this.recursive = true;
            Set<IReference> set = this.evaluateReference.getChilds(resolveLocals);
            return set;
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public String getName() {
        return this.fieldId;
    }

    @Override
    public Set<String> getTypes() {
        if (this.recursive) {
            return null;
        }
        try {
            this.recursive = true;
            Set<String> set = this.evaluateReference.getTypes();
            return set;
        }
        finally {
            this.recursive = false;
        }
    }

    public String getParentName() {
        return this.fieldId;
    }

    @Override
    public void setChild(String key, IReference ref) {
        if (this.recursive) {
            return;
        }
        try {
            this.recursive = true;
            this.evaluateReference.setChild(key, ref);
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public boolean isChildishReference() {
        return false;
    }

    public void patchRef(HostCollection collection) {
        if (this.recursive) {
            return;
        }
        try {
            this.recursive = true;
            Set<IReference> s = this.evaluateReference.getChilds(false);
            IReference queryElement = this.typeInferencer.internalEvaluate(collection, this.getName(), this.node, this.location.getModelElement(), this.cs);
            if (queryElement != null && queryElement != this) {
                while (queryElement instanceof TransparentRef) {
                    queryElement = ((TransparentRef)queryElement).evaluateReference;
                }
                if (!(queryElement instanceof CombinedOrReference) || !((CombinedOrReference)queryElement).testContains(this)) {
                    this.evaluateReference = queryElement;
                }
            }
            for (IReference r : s) {
                this.evaluateReference.setChild(r.getName(), r);
            }
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public void recordDelete(String fieldId) {
        if (this.recursive) {
            return;
        }
        try {
            this.recursive = true;
            this.evaluateReference.recordDelete(fieldId);
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public IReference getPrototype(boolean resolveLocals) {
        if (this.recursive) {
            return null;
        }
        try {
            this.recursive = true;
            IReference iReference = this.evaluateReference.getPrototype(false);
            return iReference;
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public void setPrototype(IReference ref) {
        if (this.recursive) {
            return;
        }
        try {
            this.recursive = true;
            this.evaluateReference.setPrototype(ref);
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public void addModelElements(Collection<IModelElement> toAdd) {
        if (this.location != null) {
            toAdd.add((IModelElement)new FakeField((ModelElement)this.location.getModelElement(), this.getName(), this.location.getOffset(), this.location.getLength()));
        }
    }

    @Override
    public void setLocationInformation(IReferenceLocation location) {
        this.location = location;
    }

    @Override
    public boolean isFunctionRef() {
        if (this.recursive) {
            return false;
        }
        try {
            this.recursive = true;
            boolean bl = this.evaluateReference.isFunctionRef();
            return bl;
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public boolean isLocal() {
        if (this.recursive) {
            return false;
        }
        try {
            this.recursive = true;
            boolean bl = this.evaluateReference.isLocal();
            return bl;
        }
        finally {
            this.recursive = false;
        }
    }

    @Override
    public void setLocal(boolean local) {
        if (this.recursive) {
            return;
        }
        try {
            this.recursive = true;
            this.evaluateReference.setLocal(local);
        }
        finally {
            this.recursive = false;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.fieldId + "]";
    }
}

