/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.commands.IDbgpStatckCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptStack;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;

public class ScriptStack
implements IScriptStack {
    public static final IScriptStackFrame[] NO_STACK_FRAMES = new IScriptStackFrame[0];
    private IScriptStackFrame[] frames;
    private final ScriptThread thread;

    protected IScriptStackFrame[] readFrames(IDbgpStatckCommands commands) throws DbgpException {
        IDbgpStackLevel[] levels = commands.getStackLevels();
        IScriptStackFrame[] frames = new ScriptStackFrame[levels.length];
        int i = 0;
        while (i < levels.length) {
            IDbgpStackLevel level = levels[i];
            frames[level.getLevel()] = new ScriptStackFrame(this, level);
            ++i;
        }
        return frames;
    }

    public ScriptStack(ScriptThread thread) {
        this.thread = thread;
        this.frames = new ScriptStackFrame[0];
    }

    public void update() {
        block2: {
            this.frames = NO_STACK_FRAMES;
            try {
                this.frames = this.readFrames(this.thread.getDbgpSession().getCoreCommands());
            }
            catch (DbgpException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public ScriptThread getThread() {
        return this.thread;
    }

    public int size() {
        return this.frames.length;
    }

    public boolean hasFrames() {
        return this.frames.length > 0;
    }

    public IScriptStackFrame[] getFrames() {
        return (IScriptStackFrame[])this.frames.clone();
    }

    public IScriptStackFrame getTopFrame() {
        IScriptStackFrame[] frames = this.getFrames();
        return frames.length > 0 ? frames[0] : null;
    }

    public void updateFrames() {
        int i = 0;
        while (i < this.frames.length) {
            ((ScriptStackFrame)this.frames[i]).updateVariables();
            ++i;
        }
    }
}

