/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDialogAccess;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddArchiveToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IScriptProject fScriptProject;
    static /* synthetic */ Class class$0;

    public AddArchiveToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddZIPCP_label, DLTKPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddZIPCP_tooltip);
        this.fSite = site;
    }

    public void run() {
        Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : DLTKUIPlugin.getActiveWorkbenchShell();
        final IPath[] selected = BuildpathDialogAccess.chooseExternalArchiveEntries(shell, EnvironmentManager.getEnvironment((IModelElement)this.fScriptProject));
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = AddArchiveToBuildpathAction.this.addExternalArchives(selected == null ? new IPath[]{} : selected, AddArchiveToBuildpathAction.this.fScriptProject, monitor);
                        if (result != null && result.size() > 0) {
                            AddArchiveToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                DLTKUIPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List addExternalArchives(IPath[] archivePaths, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        addedEntries = new ArrayList<BPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 4);
            if (archivePaths == null) ** GOTO lbl-1000
            i = 0;
            while (true) {
                if (i >= archivePaths.length) break;
                addedEntries.add(new BPListElement(project, 1, archivePaths[i], null, archivePaths[i].isAbsolute()));
                ++i;
            }
            monitor.worked(1);
            existingEntries = BuildpathModifier.getExistingEntries(project);
            BuildpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            BuildpathModifier.commitBuildPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            result = new ArrayList<IProjectFragment>(addedEntries.size());
            i = 0;
            while (true) {
                if (i >= addedEntries.size()) {
                    monitor.worked(1);
                    var12_11 = result;
                    var10_12 = null;
                    ** break;
                }
                entry = ((BPListElement)addedEntries.get(i)).getBuildpathEntry();
                elem = project.findProjectFragment(entry.getPath());
                if (elem != null) {
                    result.add(elem);
                }
                ++i;
            }
        }
        catch (Throwable var11_15) {
            var10_13 = null;
            monitor.done();
            throw var11_15;
        }
lbl39:
        // 1 sources

        monitor.done();
        return var12_11;
lbl-1000:
        // 1 sources

        {
            var10_14 = null;
        }
        monitor.done();
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    private boolean canHandle(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IScriptProject)) {
            return false;
        }
        this.fScriptProject = (IScriptProject)first;
        if (this.fScriptProject == null || !this.fScriptProject.exists()) {
            return false;
        }
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.fScriptProject);
        if (toolkit != null) {
            return toolkit.languageSupportZIPBuildpath();
        }
        return false;
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddArchiveToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

