/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.ScriptModelHelper;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class ScriptLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    private String fMode;
    private Button breakOnFirstLine;
    private Button enableLogging;
    private Button fProjButton;
    private Text fProjText;
    private WidgetListener fListener = new WidgetListener();

    public ScriptLaunchConfigurationTab(String mode) {
        this.fMode = mode;
    }

    public boolean canSave() {
        return this.validateProject() && this.doCanSave();
    }

    public final void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.doCreateControl(comp);
        this.createVerticalSpacer(comp, 1);
        this.createDebugOptionsGroup(comp);
        this.createCustomSections(comp);
    }

    protected void createCustomSections(Composite comp) {
    }

    protected void createDebugOptionsGroup(Composite parent) {
        if ("debug".equals(this.fMode)) {
            String text = DLTKLaunchConfigurationsMessages.ScriptLaunchConfigurationTab_debugOptions;
            Font font = parent.getFont();
            Group group = new Group(parent, 0);
            group.setText(text);
            GridData gd = new GridData(768);
            group.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            group.setFont(font);
            this.addBreakOnFirstLineButton((Composite)group);
            this.addDbgpLoggingButton((Composite)group);
        }
    }

    public final void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.doInitializeForm(config);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setMessage(null);
        this.setErrorMessage(null);
        boolean canSave = this.canSave();
        return canSave;
    }

    public final void performApply(ILaunchConfigurationWorkingCopy config) {
        String project = this.fProjText.getText().trim();
        config.setAttribute("project", project);
        if ("debug".equals(this.fMode)) {
            if (this.breakOnFirstLine != null) {
                config.setAttribute("enableBreakOnFirstLine", this.breakOnFirstLine.getSelection());
            }
            if (this.enableLogging != null) {
                config.setAttribute("enableDbgpLogging", this.enableLogging.getSelection());
            }
        }
        this.doPerformApply(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected abstract boolean breakOnFirstLinePrefEnabled(PreferencesLookupDelegate var1);

    protected abstract boolean dbpgLoggingPrefEnabled(PreferencesLookupDelegate var1);

    protected abstract boolean doCanSave();

    protected abstract void doCreateControl(Composite var1);

    protected abstract void doInitializeForm(ILaunchConfiguration var1);

    protected abstract void doPerformApply(ILaunchConfigurationWorkingCopy var1);

    protected abstract String getNatureID();

    protected abstract boolean isValidToolkit(IDLTKLanguageToolkit var1);

    private void addBreakOnFirstLineButton(Composite group) {
        this.breakOnFirstLine = this.createCheckButton(group, ScriptDebugPreferencesMessages.BreakOnFirstLineLabel);
        this.breakOnFirstLine.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.createVerticalSpacer(group, 1);
    }

    private void addDbgpLoggingButton(Composite group) {
        this.enableLogging = this.createCheckButton(group, ScriptDebugPreferencesMessages.EnableDbgpLoggingLabel);
        this.enableLogging.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.createVerticalSpacer(group, 1);
    }

    protected IScriptProject chooseProject() {
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)this.getNatureID());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_message);
        try {
            Object[] projects = ScriptModelHelper.getOpenedScriptProjects((IScriptModel)DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()), (String)this.getNatureID());
            dialog.setElements(projects);
        }
        catch (ModelException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        IScriptProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IScriptProject)dialog.getFirstResult();
        }
        return null;
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(DLTKLaunchConfigurationsMessages.mainTab_projectGroup);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton((Composite)group, DLTKLaunchConfigurationsMessages.mainTab_projectButton, null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptLaunchConfigurationTab.this.handleProjectButtonSelected();
            }
        });
    }

    protected String getLanguageName() {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getNatureID());
        if (toolkit != null) {
            return toolkit.getLanguageName();
        }
        return null;
    }

    protected IScriptProject getProject() {
        if (this.fProjText == null) {
            return null;
        }
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getScriptModel().getScriptProject(projectName);
    }

    protected String[] getProjectAndScriptNames() {
        IScriptProject project;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        ISourceModule me = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)editorInput);
        if (me != null && (project = me.getScriptProject()) != null && this.validateProject(project)) {
            String projectName = project.getProject().getName();
            IResource resource = me.getResource();
            if (resource != null) {
                String scriptName = resource.getProjectRelativePath().toPortableString();
                return new String[]{projectName, scriptName};
            }
        }
        return null;
    }

    protected final String getProjectName() {
        return this.fProjText.getText().trim();
    }

    protected IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected WidgetListener getWidgetListener() {
        return this.fListener;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected String guessProjectName() {
        return EMPTY_STRING;
    }

    protected void handleProjectButtonSelected() {
        IScriptProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        if (!this.validateProject(project)) {
            String msg = Messages.format((String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_notALangProject, (Object[])new String[]{this.getLanguageName()});
            String reason = Messages.format((String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_reasonNotALangProject, (Object[])new String[]{this.getLanguageName()});
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_invalidProject, (String)msg, (IStatus)DLTKUIStatus.createError((int)4, (String)reason, null));
            return;
        }
        String projectName = project.getElementName();
        this.setProjectName(projectName);
    }

    protected final void setProjectName(String name) {
        this.fProjText.setText(name);
        PreferencesLookupDelegate delegate = new PreferencesLookupDelegate(this.getProject());
        if ("debug".equals(this.fMode)) {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(this.breakOnFirstLinePrefEnabled(delegate));
            }
            if (this.enableLogging != null) {
                this.enableLogging.setSelection(this.dbpgLoggingPrefEnabled(delegate));
            }
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = LaunchConfigurationUtils.getProjectName((ILaunchConfiguration)config);
        if (projectName == null) {
            projectName = this.guessProjectName();
        }
        this.setProjectName(projectName);
        if ("debug".equals(this.fMode)) {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(LaunchConfigurationUtils.isBreakOnFirstLineEnabled((ILaunchConfiguration)config));
            }
            if (this.enableLogging != null) {
                this.enableLogging.setSelection(LaunchConfigurationUtils.isDbgpLoggingEnabled((ILaunchConfiguration)config));
            }
        }
    }

    protected boolean validateProject() {
        String projectName = this.getProjectName();
        if (projectName.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_selectProject);
            return false;
        }
        IScriptProject proj = this.getScriptModel().getScriptProject(projectName);
        if (proj == null || !this.validateProject(proj)) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
            return false;
        }
        return true;
    }

    protected boolean validateProject(IScriptProject project) {
        if (project == null) {
            return false;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        return toolkit != null && this.isValidToolkit(toolkit);
    }

    class WidgetListener
    implements ModifyListener,
    SelectionListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            ScriptLaunchConfigurationTab.this.setErrorMessage(null);
            if (e.getSource() == ScriptLaunchConfigurationTab.this.fProjText) {
                IScriptProject proj = ScriptLaunchConfigurationTab.this.getProject();
                if (proj != null) {
                    if (!ScriptLaunchConfigurationTab.this.validateProject(proj)) {
                        ScriptLaunchConfigurationTab.this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
                    }
                } else {
                    ScriptLaunchConfigurationTab.this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_selectProject);
                }
            }
            ScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

