/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.sourcelookup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.internal.core.AbstractExternalSourceModule;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.launching.sourcelookup.Messages;

public class DBGPSourceModule
extends AbstractExternalSourceModule {
    private ScriptStackFrame frame;
    private String cachedSource = null;

    public DBGPSourceModule(ScriptProject parent, String name, WorkingCopyOwner owner, ScriptStackFrame frame) {
        super((ModelElement)parent, name, owner);
        this.frame = frame;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBGPSourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    protected IStatus validateSourceModule(IResource resource) {
        return IModelStatus.VERIFIED_OK;
    }

    public InputStream getContents() throws CoreException {
        try {
            byte[] contents = this.lookupSource().getBytes();
            return new ByteArrayInputStream(contents);
        }
        catch (DbgpException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", Messages.DBGPSourceModule_dbgpSourceLookup, (Throwable)e));
        }
    }

    public char[] getFileName() {
        return new char[0];
    }

    public IPath getPath() {
        return new Path(this.frame.getFileName().getPath());
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        Path path = new Path(this.frame.getFileName().getPath());
        if (path.lastSegment() == null) {
            return this.frame.toString();
        }
        return "DBGP: " + path.lastSegment();
    }

    protected char[] getBufferContent() throws ModelException {
        try {
            return this.lookupSource().toCharArray();
        }
        catch (DbgpException e) {
            throw new ModelException((Throwable)e, 4);
        }
    }

    private String lookupSource() throws DbgpException {
        if (this.cachedSource == null) {
            URI uri = this.frame.getFileName();
            this.cachedSource = this.frame.getScriptThread().getDbgpSession().getCoreCommands().getSource(uri);
        }
        return this.cachedSource;
    }

    protected String getModuleType() {
        return "DLTK Remote Source Module: ";
    }

    protected String getNatureId() throws CoreException {
        IDLTKLanguageToolkit toolkit = this.lookupLanguageToolkit(this.getParent());
        if (toolkit == null) {
            return null;
        }
        return toolkit.getNatureId();
    }

    protected ISourceModule getOriginalSourceModule() {
        return new DBGPSourceModule((ScriptProject)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, this.frame);
    }
}

