/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.dltk.ui.dialogs.PropToPrefLinkArea;
import org.eclipse.dltk.ui.preferences.ControlBindingManager;
import org.eclipse.dltk.ui.preferences.IFieldValidator;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class AbstractOptionsBlock
extends OptionsConfigurationBlock
implements IPreferenceDelegate {
    private ControlBindingManager bindManager;

    public AbstractOptionsBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
        this.bindManager = new ControlBindingManager(this, context);
    }

    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Control control = this.createOptionsBlock(parent);
        this.initialize();
        return control;
    }

    protected void initialize() {
        this.bindManager.initialize();
    }

    protected abstract Control createOptionsBlock(Composite var1);

    protected final void bindControl(Button button, PreferenceKey key, Control[] dependencies) {
        this.bindManager.bindControl(button, (Object)key, dependencies);
    }

    protected final void bindControl(Text textBox, PreferenceKey key, IFieldValidator validator) {
        this.bindManager.bindControl(textBox, (Object)key, validator);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected final boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    public void performDefaults() {
        super.performDefaults();
        this.bindManager.initialize();
    }

    public final boolean getBoolean(Object key) {
        return this.getBooleanValue((PreferenceKey)key);
    }

    public final String getString(Object key) {
        return this.getValue((PreferenceKey)key);
    }

    public final void setBoolean(Object key, boolean value) {
        super.setValue((PreferenceKey)key, value);
    }

    public final void setString(Object key, String value) {
        this.setValue((PreferenceKey)key, value);
    }

    protected final IProject getProject() {
        return this.fProject;
    }

    protected final void updateStatus(IStatus status) {
        this.bindManager.updateStatus(status);
    }

    protected void createPrefLink(Composite composite, String message, String prefPageId, Object data) {
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, prefPageId, message, this.getPreferenceContainer(), data);
        area.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
    }

    protected void createPropToPrefLink(Composite composite, String message, String prefPageId, Object data) {
        PropToPrefLinkArea area = new PropToPrefLinkArea(composite, 0, prefPageId, message, this.getShell(), data);
        area.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
    }
}

