/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.console.ScriptConsoleHistory;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ui.IConsoleStyleProvider;
import org.eclipse.dltk.console.ui.IScriptConsoleViewer;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.console.ui.internal.IScriptConsoleContentHandler;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class ScriptConsoleViewer
extends TextConsoleViewer
implements IScriptConsoleViewer {
    private ScriptConsoleHistory history;
    private ScriptConsole console;
    private IConsoleStyleProvider styleProvider;

    public int getCaretPosition() {
        return this.getTextWidget().getCaretOffset();
    }

    public void enableProcessing() {
        ConsoleDocumentListener listener = this.console.getDocumentListener();
        listener.bEnabled = true;
    }

    public void disableProcessing() {
        ConsoleDocumentListener listener = this.console.getDocumentListener();
        listener.bEnabled = false;
    }

    public void setCaretPosition(final int offset) {
        this.getTextWidget().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ScriptConsoleViewer.this.getTextWidget().setCaretOffset(offset);
            }
        });
    }

    public int beginLineOffset() throws BadLocationException {
        IDocument doc = this.getDocument();
        int offset = this.getCaretPosition();
        int line = doc.getLineOfOffset(offset);
        return offset - doc.getLineOffset(line);
    }

    protected boolean isCaretOnLastLine() {
        try {
            IDocument doc = this.getDocument();
            int line = doc.getLineOfOffset(this.getCaretPosition());
            return line == doc.getNumberOfLines() - 1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new ScriptCnosoleStyledText(parent, styles);
    }

    public ScriptConsoleViewer(Composite parent, final ScriptConsole console, final IScriptConsoleContentHandler contentHandler, IConsoleStyleProvider styleProvider) {
        super(parent, (TextConsole)console);
        this.console = console;
        this.styleProvider = styleProvider;
        this.history = console.getHistory();
        console.getDocumentListener().addViewer(this);
        final StyledText styledText = this.getTextWidget();
        this.setEditable(false);
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScriptConsoleViewer.this.setCaretPosition(ScriptConsoleViewer.this.getDocument().getLength());
                styledText.removeFocusListener((FocusListener)this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                try {
                    if (event.character != '\u0000') {
                        ConsoleDocumentListener listener = console.getDocumentListener();
                        int selStart = ScriptConsoleViewer.this.getSelectedRange().x;
                        int selEnd = ScriptConsoleViewer.this.getSelectedRange().x + ScriptConsoleViewer.this.getSelectedRange().y;
                        int clOffset = listener.getCommandLineOffset();
                        int clLength = listener.getCommandLineLength();
                        if (selStart < clOffset) {
                            int selLength;
                            if (selEnd < clOffset) {
                                selStart = clOffset + clLength;
                                selLength = 0;
                            } else {
                                selStart = clOffset;
                                selLength = selEnd - selStart;
                            }
                            ScriptConsoleViewer.this.setSelectedRange(selStart, selLength);
                        }
                        if (ScriptConsoleViewer.this.beginLineOffset() < console.getDocumentListener().getLastLineReadOnlySize()) {
                            event.doit = false;
                            return;
                        }
                        if (event.character == '\r') {
                            ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            return;
                        }
                        if (event.keyCode == 9) {
                            event.doit = false;
                            return;
                        }
                        if (event.keyCode == 32 && (event.stateMask & 0x40000) > 0) {
                            event.doit = false;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 9) {
                    contentHandler.contentAssistRequired();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.clear();
    }

    public String getCommandLine() {
        try {
            return this.console.getDocumentListener().getCommandLine();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getCommandLineOffset() {
        try {
            return this.console.getDocumentListener().getCommandLineOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void clear() {
        this.console.getDocumentListener().clear();
    }

    public void insertText(String text) {
        this.getTextWidget().append(text);
    }

    public boolean canDoOperation(int operation) {
        boolean canDoOperation = super.canDoOperation(operation);
        if (canDoOperation) {
            switch (operation) {
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    canDoOperation = this.isCaretOnLastLine();
                }
            }
        }
        return canDoOperation;
    }

    public void setStyleProvider(IConsoleStyleProvider provider) {
        this.styleProvider = provider;
    }

    public static class ConsoleDocumentListener
    implements IDocumentListener {
        private boolean bEnabled = true;
        private ICommandHandler handler;
        private ScriptConsolePrompt prompt;
        private ScriptConsoleHistory history;
        private int offset;
        private IDocument doc;
        private List viewerList = new ArrayList();

        private void addViewer(ScriptConsoleViewer viewer) {
            this.viewerList.add(viewer);
        }

        protected void connectListener() {
            this.doc.addDocumentListener((IDocumentListener)this);
        }

        protected void disconnectListener() {
            this.doc.removeDocumentListener((IDocumentListener)this);
        }

        public void clear() {
            this.disconnectListener();
            this.doc.set("");
            Iterator iter = this.viewerList.iterator();
            while (iter.hasNext()) {
                ((ScriptConsoleViewer)iter.next()).setCaretPosition(this.doc.getLength());
            }
            this.connectListener();
        }

        public ConsoleDocumentListener(ICommandHandler handler, ScriptConsolePrompt prompt, ScriptConsoleHistory history) {
            this.prompt = prompt;
            this.handler = handler;
            this.history = history;
            this.offset = 0;
            this.doc = null;
        }

        public void setDocument(IDocument doc) {
            if (this.doc != null) {
                this.disconnectListener();
            }
            this.doc = doc;
            if (this.doc != null) {
                this.connectListener();
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        protected void handleCommandLine() throws BadLocationException, IOException {
            String command = this.getCommandLine();
            this.appendDelimeter();
            this.processResult(this.handler.handleCommand(command));
        }

        protected void processResult(String result) throws BadLocationException {
            if (result != null) {
                int start = this.appendText(result);
                Iterator iter = this.viewerList.iterator();
                while (iter.hasNext()) {
                    StyleRange[] styles;
                    ScriptConsoleViewer viewer = (ScriptConsoleViewer)iter.next();
                    if (viewer.styleProvider == null || (styles = viewer.styleProvider.createInterpreterOutputStyle(result, start)) == null || styles.length <= 0) continue;
                    this.addToPartitioner(viewer, styles);
                }
                this.history.commit();
                this.offset = this.getLastLineLength();
            }
            this.appendInvitation();
        }

        private void addToPartitioner(ScriptConsoleViewer viewer, StyleRange[] styles) {
            IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
            if (partitioner instanceof ScriptConsolePartitioner) {
                ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                scriptConsolePartitioner.addRanges(styles);
                viewer.getTextWidget().redraw();
            }
        }

        protected void proccessAddition(int offset, String text) {
            block7: {
                if (!this.bEnabled) {
                    return;
                }
                try {
                    String delim = this.getDelimeter();
                    text = this.doc.get(offset, this.doc.getLength() - offset);
                    this.doc.replace(offset, text.length(), "");
                    text = text.replaceAll("\r\n|\n|\r", delim);
                    int start = 0;
                    int index = -1;
                    while ((index = text.indexOf(delim, start)) != -1) {
                        String cmd = text.substring(start, index);
                        this.appendText(cmd);
                        Iterator iter = this.viewerList.iterator();
                        while (iter.hasNext()) {
                            StyleRange[] styles;
                            ScriptConsoleViewer viewer = (ScriptConsoleViewer)iter.next();
                            if (viewer.styleProvider == null || (styles = viewer.styleProvider.createUserInputStyle(this.getCommandLine(), this.getCommandLineOffset())) == null || styles.length <= 0) continue;
                            this.addToPartitioner(viewer, styles);
                        }
                        this.history.update(this.getCommandLine());
                        start = index + delim.length();
                        this.handleCommandLine();
                    }
                    this.appendText(text.substring(start, text.length()));
                    this.history.update(this.getCommandLine());
                }
                catch (BadLocationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }

        public void documentChanged(DocumentEvent event) {
            this.disconnectListener();
            this.proccessAddition(event.getOffset(), event.getText());
            this.connectListener();
        }

        protected int appendText(String text) throws BadLocationException {
            int offset = this.doc.getLength();
            this.doc.replace(this.doc.getLength(), 0, text);
            return offset;
        }

        public void appendInvitation() throws BadLocationException {
            int start = this.doc.getLength();
            this.appendText(this.prompt.toString());
            Iterator iter = this.viewerList.iterator();
            while (iter.hasNext()) {
                StyleRange[] styles;
                ScriptConsoleViewer viewer = (ScriptConsoleViewer)iter.next();
                viewer.setCaretPosition(this.doc.getLength());
                viewer.revealEndOfDocument();
                if (viewer.styleProvider == null || (styles = viewer.styleProvider.createPromptStyle(this.prompt, start)) == null || styles.length <= 0) continue;
                this.addToPartitioner(viewer, styles);
            }
        }

        public void appendDelimeter() throws BadLocationException {
            this.appendText(this.getDelimeter());
        }

        protected String getDelimeter() {
            return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
        }

        protected int getLastLineLength() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineLength(lastLine);
        }

        public int getLastLineReadOnlySize() {
            return this.prompt.toString().length() + this.offset;
        }

        public int getCommandLineOffset() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineOffset(lastLine) + this.getLastLineReadOnlySize();
        }

        public int getCommandLineLength() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineLength(lastLine) - this.getLastLineReadOnlySize();
        }

        public String getCommandLine() throws BadLocationException {
            return this.doc.get(this.getCommandLineOffset(), this.getCommandLineLength());
        }

        public void setCommandLine(String command) throws BadLocationException {
            this.doc.replace(this.getCommandLineOffset(), this.getCommandLineLength(), command);
        }
    }

    private class ScriptCnosoleStyledText
    extends StyledText {
        public ScriptCnosoleStyledText(Composite parent, int style) {
            super(parent, style);
        }

        public void invokeAction(int action) {
            if (ScriptConsoleViewer.this.isCaretOnLastLine()) {
                try {
                    switch (action) {
                        case 0x1000001: {
                            ScriptConsoleViewer.this.history.prev();
                            ScriptConsoleViewer.this.console.getDocumentListener().setCommandLine(ScriptConsoleViewer.this.history.get());
                            this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            return;
                        }
                        case 0x1000002: {
                            ScriptConsoleViewer.this.history.next();
                            ScriptConsoleViewer.this.console.getDocumentListener().setCommandLine(ScriptConsoleViewer.this.history.get());
                            this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            return;
                        }
                        case 8: {
                            if (this.getCaretOffset() <= ScriptConsoleViewer.this.getCommandLineOffset()) {
                                return;
                            }
                            break;
                        }
                        case 127: {
                            if (this.getCaretOffset() < ScriptConsoleViewer.this.getCommandLineOffset()) {
                                return;
                            }
                            break;
                        }
                        case 262152: {
                            return;
                        }
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return;
                }
                super.invokeAction(action);
                if (ScriptConsoleViewer.this.isCaretOnLastLine() && this.getCaretOffset() <= ScriptConsoleViewer.this.getCommandLineOffset()) {
                    this.setCaretOffset(ScriptConsoleViewer.this.getCommandLineOffset());
                }
            } else {
                super.invokeAction(action);
            }
        }

        public void paste() {
            if (ScriptConsoleViewer.this.isCaretOnLastLine()) {
                super.paste();
            }
        }
    }
}

