/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.util.Util;

public class LazyDLTKSearchDocument
extends DLTKSearchDocument {
    public LazyDLTKSearchDocument(String path, SearchParticipant participant, boolean external, IProject project) {
        super(path, null, participant, external, project);
    }

    public LazyDLTKSearchDocument(String path, IPath containerPath, char[] contents, SearchParticipant participant, boolean external, IProject project) {
        super(path, containerPath, contents, participant, external, project);
    }

    private void loadContents() {
        if (this.charContents == null) {
            this.charContents = this.getDocumentContents(this.getPath());
        }
    }

    private char[] getDocumentContents(String documentPath) {
        block4: {
            Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(documentPath), true);
            try {
                if (target instanceof IFile) {
                    return Util.getResourceContentsAsCharArray((IFile)target);
                }
                if (target instanceof IFileHandle) {
                    return Util.getResourceContentsAsCharArray((IFileHandle)target);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new char[0];
    }

    public String getContents() {
        this.loadContents();
        return new String(this.charContents);
    }

    public char[] getCharContents() {
        this.loadContents();
        return this.charContents;
    }
}

