/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.search.AbstractSearchScope;
import org.eclipse.dltk.internal.core.util.Util;

public class DLTKSearchScope
extends AbstractSearchScope {
    private ArrayList elements;
    private ArrayList projectPaths = new ArrayList();
    private int[] projectIndexes;
    private String[] containerPaths;
    private String[] relativePaths;
    private boolean[] isPkgPath;
    protected AccessRuleSet[] pathRestrictions;
    private int pathsCount;
    private int threshold;
    private IPath[] enclosingProjectsAndArchives;
    protected final IDLTKLanguageToolkit toolkit;
    public static final AccessRuleSet NOT_ENCLOSED = new AccessRuleSet(null, null);

    public DLTKSearchScope(IDLTKLanguageToolkit toolkit) {
        this(toolkit, 5);
    }

    private DLTKSearchScope(IDLTKLanguageToolkit toolkit, int size) {
        this.toolkit = toolkit;
        this.initialize(size);
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return this.toolkit;
    }

    private void addEnclosingProjectOrArchive(IPath path) {
        int length = this.enclosingProjectsAndArchives.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjectsAndArchives[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjectsAndArchives = new IPath[length + 1];
        System.arraycopy(this.enclosingProjectsAndArchives, 0, this.enclosingProjectsAndArchives, 0, length);
        this.enclosingProjectsAndArchives[length] = path;
    }

    public void add(ScriptProject project, int includeMask, HashSet visitedProject) throws ModelException {
        this.add(project, null, includeMask, visitedProject, null);
    }

    void add(ScriptProject scriptProject, IPath pathToAdd, int includeMask, HashSet visitedProjects, IBuildpathEntry referringEntry) throws ModelException {
        if (!this.natureFilter(scriptProject)) {
            return;
        }
        IProject project = scriptProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        IPath projectPath = project.getFullPath();
        String projectPathString = projectPath.toString();
        this.addEnclosingProjectOrArchive(projectPath);
        IBuildpathEntry[] entries = scriptProject.getResolvedBuildpath();
        IScriptModel model = scriptProject.getModel();
        ModelManager.PerProjectInfo perProjectInfo = scriptProject.getPerProjectInfo();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            block17: {
                BuildpathEntry cpEntry;
                AccessRuleSet access;
                IBuildpathEntry entry;
                block16: {
                    entry = entries[i];
                    access = null;
                    cpEntry = (BuildpathEntry)entry;
                    if (referringEntry == null) break block16;
                    if (!entry.isExported() && entry.getEntryKind() != 3) break block17;
                    cpEntry = cpEntry.combineWith((BuildpathEntry)referringEntry);
                }
                access = cpEntry.getAccessRuleSet();
                block0 : switch (entry.getEntryKind()) {
                    case 1: {
                        IPath path;
                        IBuildpathEntry rawEntry = null;
                        Map resolvedPathToRawEntries = perProjectInfo.resolvedPathToRawEntries;
                        if (resolvedPathToRawEntries != null) {
                            rawEntry = (IBuildpathEntry)resolvedPathToRawEntries.get(entry.getPath());
                        }
                        if (rawEntry == null) break;
                        switch (rawEntry.getEntryKind()) {
                            case 1: {
                                if ((includeMask & 2) == 0) break;
                                path = entry.getPath();
                                if (pathToAdd != null && !pathToAdd.equals((Object)path)) break block0;
                                String pathToString = path.toString();
                                this.add(projectPath.toString(), "", pathToString, false, access);
                                this.addEnclosingProjectOrArchive(path);
                                break;
                            }
                            case 5: {
                                IBuildpathContainer container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), scriptProject);
                                if (container == null || (container.getKind() != 1 || (includeMask & 2) == 0) && (includeMask & 4) == 0) break block0;
                                IPath path2 = entry.getPath();
                                if (pathToAdd != null && !pathToAdd.equals((Object)path2)) break block0;
                                String pathToString = path2.toString();
                                this.add(projectPath.toString(), "", pathToString, false, access);
                                this.addEnclosingProjectOrArchive(path2);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((includeMask & 8) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add((ScriptProject)model.getScriptProject(entry.getPath().lastSegment()), null, includeMask, visitedProjects, cpEntry);
                        break;
                    }
                    case 3: {
                        if ((includeMask & 1) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add(projectPath.toString(), Util.relativePath(path, 1), projectPathString, false, access);
                    }
                }
            }
            ++i;
        }
    }

    public void add(IModelElement element) throws ModelException {
        if (!this.natureFilter(element)) {
            return;
        }
        IPath containerPath = null;
        String containerPathToString = null;
        int includeMask = 7;
        switch (element.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                this.add((ScriptProject)element, null, includeMask, new HashSet(2), null);
                break;
            }
            case 3: {
                IProjectFragment root = (IProjectFragment)element;
                String projectPath = null;
                if (!root.isExternal()) {
                    IPath rootPath = root.getPath();
                    containerPath = root.getKind() == 1 ? root.getParent().getPath() : rootPath;
                    containerPathToString = containerPath.toString();
                    IResource rootResource = root.getResource();
                    projectPath = root.getScriptProject().getPath().toString();
                    if (rootResource != null && rootResource.isAccessible()) {
                        String relativePath = Util.relativePath(rootResource.getFullPath(), containerPath.segmentCount());
                        this.add(projectPath, relativePath, containerPathToString, false, null);
                        break;
                    }
                    this.add(projectPath, "", containerPathToString, false, null);
                    break;
                }
                projectPath = root.getScriptProject().getPath().toString();
                containerPath = root.getPath();
                containerPathToString = containerPath.toString();
                this.add(projectPath, "", containerPathToString, false, null);
                break;
            }
            case 4: {
                IProjectFragment root = (IProjectFragment)element.getParent();
                String projectPath = root.getScriptProject().getPath().toString();
                if (root.isArchive()) {
                    if (DLTKCore.DEBUG) {
                        System.err.println("TODO: Check. Bug possible...");
                    }
                    String relativePath = String.valueOf(((ScriptFolder)element).getPath().toString()) + '/';
                    containerPath = root.getPath();
                    containerPathToString = containerPath.toString();
                    this.add(projectPath, relativePath, containerPathToString, true, null);
                    break;
                }
                IResource resource = element.getResource();
                if (resource == null) break;
                containerPath = resource.isAccessible() ? (root.getKind() == 1 ? root.getParent().getPath() : root.getPath()) : resource.getParent().getFullPath();
                containerPathToString = containerPath.toString();
                String relativePath = Util.relativePath(resource.getFullPath(), containerPath.segmentCount());
                this.add(projectPath, relativePath, containerPathToString, true, null);
                break;
            }
            default: {
                String relativePath;
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                IProjectFragment root = (IProjectFragment)element.getAncestor(3);
                String projectPath = root.getScriptProject().getPath().toString();
                if (root.getKind() == 1) {
                    containerPath = root.getParent().getPath();
                    relativePath = Util.relativePath(this.getPath(element, false), 1);
                } else {
                    containerPath = root.getPath();
                    relativePath = this.getPath(element, true).toString();
                }
                containerPathToString = containerPath.toString();
                this.add(projectPath, relativePath, containerPathToString, false, null);
            }
        }
        if (containerPath != null) {
            this.addEnclosingProjectOrArchive(containerPath);
        }
    }

    private boolean natureFilter(IModelElement element) {
        IDLTKLanguageToolkit elementToolkit = DLTKLanguageManager.getLanguageToolkit(element);
        if (this.toolkit == null) {
            return true;
        }
        return elementToolkit != null && elementToolkit.getNatureId().equals(this.toolkit.getNatureId());
    }

    private void add(String projectPath, String relativePath, String containerPath, boolean isPackage, AccessRuleSet access) {
        String currentContainerPath;
        String currentRelativePath;
        containerPath = this.normalize(containerPath);
        relativePath = this.normalize(relativePath);
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentRelativePath = this.relativePaths[index]) != null && (currentContainerPath = this.containerPaths[index]) != null) {
            if (currentRelativePath.equals(relativePath) && currentContainerPath.equals(containerPath)) {
                return;
            }
            if (++index != length) continue;
            index = 0;
        }
        int idx = this.projectPaths.indexOf(projectPath);
        if (idx == -1) {
            this.projectPaths.add(projectPath);
            idx = this.projectPaths.indexOf(projectPath);
        }
        this.projectIndexes[index] = idx;
        this.relativePaths[index] = relativePath;
        this.containerPaths[index] = containerPath;
        this.isPkgPath[index] = isPackage;
        if (this.pathRestrictions != null) {
            this.pathRestrictions[index] = access;
        } else if (access != null) {
            this.pathRestrictions = new AccessRuleSet[this.relativePaths.length];
            this.pathRestrictions[index] = access;
        }
        if (++this.pathsCount > this.threshold) {
            this.rehash();
        }
    }

    public boolean encloses(String resourcePathString) {
        int separatorIndex = resourcePathString.indexOf("|");
        if (separatorIndex != -1) {
            String relativePath;
            String zipPath = resourcePathString.substring(0, separatorIndex);
            return this.indexOf(zipPath, relativePath = resourcePathString.substring(separatorIndex + 1)) >= 0;
        }
        return this.indexOf(resourcePathString) >= 0;
    }

    private int indexOf(String fullPath) {
        int i = 0;
        int length = this.relativePaths.length;
        while (i < length) {
            String currentRelativePath = this.relativePaths[i];
            if (currentRelativePath != null) {
                String currentFullPath;
                String currentContainerPath = this.containerPaths[i];
                String string = currentFullPath = currentRelativePath.length() == 0 ? currentContainerPath : String.valueOf(currentContainerPath) + "/" + currentRelativePath;
                if (this.encloses(currentFullPath, fullPath, i)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(String containerPath, String relativePath) {
        String currentContainerPath;
        containerPath = this.normalize(containerPath);
        relativePath = this.normalize(relativePath);
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentContainerPath = this.containerPaths[index]) != null) {
            String currentRelativePath;
            if (currentContainerPath.equals(containerPath) && this.encloses(currentRelativePath = this.relativePaths[index], relativePath, index)) {
                return index;
            }
            if (++index != length) continue;
            index = 0;
        }
        return -1;
    }

    private boolean encloses(String enclosingPath, String path, int index) {
        int enclosingLength;
        enclosingPath = new Path(enclosingPath).toString();
        Path realPath = new Path(path = new Path(this.normalize(path)).toString());
        if (!DLTKContentTypeManager.isValidFileNameForContentType(this.toolkit, (IPath)realPath)) {
            return false;
        }
        int pathLength = path.length();
        if (pathLength < (enclosingLength = enclosingPath.length())) {
            return false;
        }
        if (enclosingLength == 0) {
            return true;
        }
        if (pathLength == enclosingLength) {
            return path.equals(enclosingPath);
        }
        if (!this.isPkgPath[index]) {
            return path.startsWith(enclosingPath) && path.charAt(enclosingLength) == '/';
        }
        return path.startsWith(enclosingPath) && (enclosingPath.length() == path.lastIndexOf(47) || enclosingPath.length() == path.length());
    }

    public boolean encloses(IModelElement element) {
        IDLTKLanguageToolkit elementToolkit = DLTKLanguageManager.getLanguageToolkit(element);
        if (!this.toolkit.getNatureId().equals(elementToolkit.getNatureId())) {
            return false;
        }
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IModelElement scopeElement = (IModelElement)this.elements.get(i);
                IModelElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        IProjectFragment root = (IProjectFragment)element.getAncestor(3);
        if (root != null && root.isArchive()) {
            IPath relativePath;
            IPath rootPath = root.getPath();
            String rootPathToString = rootPath.toString();
            return this.indexOf(rootPathToString, (relativePath = this.getPath(element, true)).toString()) >= 0;
        }
        String fullResourcePathString = this.getPath(element, false).toString();
        return this.indexOf(fullResourcePathString) >= 0;
    }

    public IPath[] enclosingProjectsAndZips() {
        return this.enclosingProjectsAndArchives;
    }

    private IPath getPath(IModelElement element, boolean relativeToRoot) {
        switch (element.getElementType()) {
            case 1: {
                return Path.EMPTY;
            }
            case 2: {
                return element.getPath();
            }
            case 3: {
                if (relativeToRoot) {
                    return Path.EMPTY;
                }
                return element.getPath();
            }
            case 4: {
                String relativePath = String.valueOf(((ScriptFolder)element).getRelativePath().toString()) + '/';
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(relativePath));
            }
            case 5: {
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(element.getElementName()));
            }
        }
        return this.getPath(element.getParent(), relativeToRoot);
    }

    public AccessRuleSet getAccessRuleSet(String relativePath, String containerPath) {
        int index;
        if (containerPath.startsWith("#special#mixin#")) {
            containerPath = containerPath.substring("#special#mixin#".length());
        }
        if ((index = this.indexOf(containerPath, relativePath)) == -1) {
            return NOT_ENCLOSED;
        }
        if (this.pathRestrictions == null) {
            return null;
        }
        return this.pathRestrictions[index];
    }

    protected void initialize(int size) {
        this.pathsCount = 0;
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.relativePaths = new String[extraRoom];
        this.containerPaths = new String[extraRoom];
        this.projectIndexes = new int[extraRoom];
        this.isPkgPath = new boolean[extraRoom];
        this.pathRestrictions = null;
        this.enclosingProjectsAndArchives = new IPath[0];
    }

    private String normalize(String path) {
        int pathLength = path.length();
        int index = pathLength - 1;
        while (index >= 0 && path.charAt(index) == '/') {
            --index;
        }
        if (index != pathLength - 1) {
            return path.substring(0, index + 1);
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IModelElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                IModelElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IModelElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                IModelElement element = delta.getElement();
                if (!this.encloses(element)) return;
                if (this.elements != null) {
                    this.elements.remove(element);
                }
                IPath path = null;
                switch (element.getElementType()) {
                    case 2: {
                        path = ((IScriptProject)element).getProject().getFullPath();
                    }
                    case 3: {
                        if (path == null) {
                            path = ((IProjectFragment)element).getPath();
                        }
                        int toRemove = -1;
                        int i = 0;
                        while (i < this.pathsCount) {
                            if (this.relativePaths[i].equals(path.toString())) {
                                toRemove = i;
                                break;
                            }
                            ++i;
                        }
                        if (toRemove == -1) return;
                        this.relativePaths[toRemove] = null;
                        this.rehash();
                    }
                }
            }
        }
    }

    public IProjectFragment projectFragment(String resourcePathString) {
        int index = -1;
        int separatorIndex = resourcePathString.indexOf("|");
        boolean isZIPFile = separatorIndex != -1;
        boolean isBuiltin = resourcePathString.startsWith("#special#builtin#");
        if (isZIPFile) {
            String zipPath = resourcePathString.substring(0, separatorIndex);
            String relativePath = resourcePathString.substring(separatorIndex + 1);
            index = this.indexOf(zipPath, relativePath);
        } else {
            index = this.indexOf(resourcePathString);
        }
        if (index >= 0) {
            String projectPath;
            int idx = this.projectIndexes[index];
            String string = projectPath = idx == -1 ? null : (String)this.projectPaths.get(idx);
            if (projectPath != null) {
                IScriptProject project = DLTKCore.create(ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath));
                if (isZIPFile) {
                    return project.getProjectFragment(this.containerPaths[index]);
                }
                if (isBuiltin) {
                    return project.getProjectFragment(this.containerPaths[index]);
                }
                Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), Path.fromPortableString((String)(String.valueOf(this.containerPaths[index]) + '/' + this.relativePaths[index])), false);
                if (target instanceof IProject) {
                    return project.getProjectFragment((IResource)((IProject)target));
                }
                if (target instanceof IResource) {
                    IModelElement element = DLTKCore.create((IResource)target);
                    return (IProjectFragment)element.getAncestor(3);
                }
                if (target instanceof IFileHandle) {
                    try {
                        IProjectFragment[] fragments = project.getProjectFragments();
                        IFileHandle t = (IFileHandle)target;
                        String absPath = t.getFullPath().toString();
                        int i = 0;
                        while (i < fragments.length) {
                            ExternalProjectFragment ep;
                            String pPath;
                            IProjectFragment f = fragments[i];
                            if (f instanceof ExternalProjectFragment && absPath.equals(pPath = (ep = (ExternalProjectFragment)f).getPath().toString())) {
                                return f;
                            }
                            ++i;
                        }
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private void rehash() {
        DLTKSearchScope newScope = new DLTKSearchScope(this.toolkit, this.pathsCount * 2);
        newScope.projectPaths.ensureCapacity(this.projectPaths.size());
        int i = this.relativePaths.length;
        while (--i >= 0) {
            String currentPath = this.relativePaths[i];
            if (currentPath == null) continue;
            int idx = this.projectIndexes[i];
            String projectPath = idx == -1 ? null : (String)this.projectPaths.get(idx);
            newScope.add(projectPath, currentPath, this.containerPaths[i], this.isPkgPath[i], this.pathRestrictions == null ? null : this.pathRestrictions[i]);
        }
        this.relativePaths = newScope.relativePaths;
        this.containerPaths = newScope.containerPaths;
        this.projectPaths = newScope.projectPaths;
        this.projectIndexes = newScope.projectIndexes;
        this.isPkgPath = newScope.isPkgPath;
        this.pathRestrictions = newScope.pathRestrictions;
        this.threshold = newScope.threshold;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("JavaSearchScope on ");
        if (this.elements != null) {
            result.append("[");
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                ModelElement element = (ModelElement)this.elements.get(i);
                result.append("\n\t");
                result.append(element.toStringWithAncestors());
                ++i;
            }
            result.append("\n]");
        } else if (this.pathsCount == 0) {
            result.append("[empty scope]");
        } else {
            result.append("[");
            int i = 0;
            while (i < this.relativePaths.length) {
                String path = this.relativePaths[i];
                if (path != null) {
                    result.append("\n\t");
                    result.append(this.containerPaths[i]);
                    if (path.length() > 0) {
                        result.append('/');
                        result.append(path);
                    }
                }
                ++i;
            }
            result.append("\n]");
        }
        return result.toString();
    }
}

