/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserExtension;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceParserUtil {
    private static final Object AST = "ast";
    private static final Object FLAGS = "flags";

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, 0, null);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, IContentAction action) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, 0, action);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, int flags) {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        ISourceModuleInfoCache.ISourceModuleInfo sourceModuleInfo = sourceModuleInfoCache.get(module);
        return SourceParserUtil.getModuleDeclaration(module, reporter, sourceModuleInfo, flags, null);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, int flags, IContentAction action) {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        ISourceModuleInfoCache.ISourceModuleInfo sourceModuleInfo = sourceModuleInfoCache.get(module);
        return SourceParserUtil.getModuleDeclaration(module, reporter, sourceModuleInfo, flags, action);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, mifo, 0, null);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo, IContentAction action) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, mifo, 0, action);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags, IContentAction action) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(module);
        if (toolkit == null) {
            return null;
        }
        ModuleDeclaration moduleDeclaration = null;
        if (mifo != null) {
            moduleDeclaration = (ModuleDeclaration)mifo.get(AST);
            Integer flag = (Integer)mifo.get(FLAGS);
            if (flag != null && flag != flags) {
                moduleDeclaration = null;
            }
        }
        if (moduleDeclaration == null) {
            if (reporter != null) {
                reporter.clearMarkers();
            }
            ISourceParser sourceParser = null;
            sourceParser = DLTKLanguageManager.getSourceParser(toolkit.getNatureId());
            if (sourceParser != null) {
                if (sourceParser instanceof ISourceParserExtension) {
                    ((ISourceParserExtension)((Object)sourceParser)).setFlags(flags);
                }
                try {
                    char[] sourceAsCharArray = module.getSourceAsCharArray();
                    moduleDeclaration = sourceParser.parse(module.getPath().toString().toCharArray(), sourceAsCharArray, reporter);
                    if (action != null) {
                        action.run(module, sourceAsCharArray);
                    }
                }
                catch (ModelException e) {
                    ILog log = DLTKCore.getDefault().getLog();
                    Status status = new Status(4, "org.eclipse.dltk.core", "Error to get source module content", (Throwable)((Object)e));
                    log.log((IStatus)status);
                }
                if (moduleDeclaration != null && mifo != null) {
                    mifo.put(AST, moduleDeclaration);
                    mifo.put(FLAGS, new Integer(flags));
                }
            }
        }
        return moduleDeclaration;
    }

    public static ModuleDeclaration getModuleDeclaration(char[] filename, char[] content, String nature, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        return SourceParserUtil.getModuleDeclaration(filename, content, nature, reporter, mifo, 0);
    }

    public static ModuleDeclaration getModuleDeclaration(char[] filename, char[] content, String nature, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags) {
        ModuleDeclaration moduleDeclaration;
        ISourceParser sourceParser = DLTKLanguageManager.getSourceParser(nature);
        if (sourceParser instanceof ISourceParserExtension) {
            ((ISourceParserExtension)((Object)sourceParser)).setFlags(flags);
        }
        if ((moduleDeclaration = SourceParserUtil.getModuleFromCache(mifo, flags)) == null) {
            if (reporter != null) {
                reporter.clearMarkers();
            }
            moduleDeclaration = sourceParser.parse(filename, content, reporter);
            SourceParserUtil.putModuleToCache(mifo, moduleDeclaration, flags);
        }
        return moduleDeclaration;
    }

    public static ModuleDeclaration getModuleFromCache(ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags) {
        if (mifo != null) {
            Integer flag = (Integer)mifo.get(FLAGS);
            if (flag != null && flag != flags) {
                return null;
            }
            return (ModuleDeclaration)mifo.get(AST);
        }
        return null;
    }

    public static void putModuleToCache(ISourceModuleInfoCache.ISourceModuleInfo info, ModuleDeclaration module, int flags) {
        if (info != null) {
            info.put(AST, module);
            info.put(FLAGS, new Integer(flags));
        }
    }

    public static void parseSourceModule(ISourceModule module, ISourceElementParser parser) {
        block2: {
            try {
                char[] contents = module.getSourceAsCharArray();
                ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
                ISourceModuleInfoCache.ISourceModuleInfo mifo = sourceModuleInfoCache.get(module);
                parser.parseSourceModule(contents, mifo, module.getPath().toString().toCharArray());
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public static interface IContentAction {
        public void run(ISourceModule var1, char[] var2);
    }
}

