/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.core.internal.rse.MyHostShellProcessAdapter;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.core.internal.rse.perfomance.RSEPerfomanceStatistics;
import org.eclipse.dltk.internal.launching.execution.EFSDeployment;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

public class RSEExecEnvironment
implements IExecutionEnvironment {
    private static final String EXIT_CMD = "exit";
    private RSEEnvironment environment;
    private static int counter = -1;
    private static Map hostToEnvironment = new HashMap();

    public RSEExecEnvironment(RSEEnvironment env) {
        this.environment = env;
    }

    public IDeployment createDeployment() {
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(4);
        }
        try {
            String rootPath = String.valueOf(this.getTempDir()) + this.environment.getSeparator() + this.getTempName("dltk", ".tmp");
            URI rootUri = this.createRemoteURI(this.environment.getHost(), rootPath);
            return new EFSDeployment((IEnvironment)this.environment, rootUri);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private URI createRemoteURI(IHost host, String rootPath) {
        return RSEFileSystem.getURIFor((String)host.getHostName(), (String)rootPath);
    }

    private IShellServiceSubSystem getShellServiceSubSystem(IHost host) {
        ISubSystem[] subsys = host.getSubSystems();
        int i = 0;
        while (i < subsys.length) {
            if (subsys[i] instanceof IShellServiceSubSystem) {
                return (IShellServiceSubSystem)subsys[i];
            }
            ++i;
        }
        return null;
    }

    private String getTempName(String prefix, String suffix) {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return String.valueOf(prefix) + Integer.toString(++counter) + suffix;
    }

    private String getTempDir() {
        IShellServiceSubSystem system;
        block3: {
            system = this.getShellServiceSubSystem(this.environment.getHost());
            try {
                system.connect((IProgressMonitor)new NullProgressMonitor(), false);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        String temp = system.getConnectorService().getTempDirectory();
        if (temp.length() == 0) {
            temp = "/tmp";
        }
        return temp;
    }

    public Process exec(String[] cmdLine, IPath workingDir, String[] environment) throws CoreException {
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(2);
        }
        long start = System.currentTimeMillis();
        IShellServiceSubSystem shell = this.getShellServiceSubSystem(this.environment.getHost());
        try {
            shell.connect(null, false);
        }
        catch (Exception e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        if (!shell.isConnected()) {
            return null;
        }
        IShellService shellService = shell.getShellService();
        IHostShell hostShell = null;
        String workingDirectory = null;
        workingDirectory = workingDir != null ? this.environment.convertPathToString(workingDir) : "/";
        try {
            hostShell = shellService.runCommand(workingDirectory, "bash", environment, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e1) {
            DLTKRSEPlugin.log(e1);
            return null;
        }
        if (environment != null) {
            int i = 0;
            while (i < environment.length) {
                hostShell.writeToShell("export " + this.toShellArguments(environment[i]));
                ++i;
            }
        }
        String pattern = "DLTK_INITIAL_PREFIX_EXECUTION_STRING:" + String.valueOf(System.currentTimeMillis());
        String echoCommand = "echo \"" + pattern + "\"";
        String command = this.createCommand(cmdLine);
        hostShell.writeToShell(String.valueOf(echoCommand) + " ;" + command + " ;" + echoCommand + " ;" + EXIT_CMD);
        MyHostShellProcessAdapter p = null;
        try {
            p = new MyHostShellProcessAdapter(hostShell, pattern);
        }
        catch (Exception exception) {
            if (p != null) {
                ((Process)p).destroy();
            }
            throw new RuntimeException("Failed to run remote command");
        }
        long end = System.currentTimeMillis();
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(9, end - start);
        }
        return p;
    }

    private String toShellArguments(String cmd) {
        String replaceAll = cmd.replaceAll(" ", "\\\\ ");
        return replaceAll;
    }

    private String createWorkingDir(IPath workingDir) {
        if (workingDir == null) {
            return ".";
        }
        return workingDir.toPortableString();
    }

    private String createCommand(String[] cmdLine) {
        StringBuffer cmd = new StringBuffer();
        int i = 1;
        while (i < cmdLine.length) {
            cmd.append(cmdLine[i]);
            if (i != cmdLine.length - 1) {
                cmd.append(" ");
            }
            ++i;
        }
        return String.valueOf(cmdLine[0]) + " " + cmd.toString();
    }

    public Map getEnvironmentVariables(boolean realyNeed) {
        HashMap result;
        long start;
        block8: {
            if (!realyNeed) {
                return new HashMap();
            }
            start = System.currentTimeMillis();
            if (hostToEnvironment.containsKey(this.environment.getHost())) {
                return (Map)hostToEnvironment.get(this.environment.getHost());
            }
            result = new HashMap();
            try {
                Process process = this.exec(new String[]{"set"}, (IPath)new Path(""), null);
                if (process == null) break block8;
                final BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                int pos = (line = line.trim()).indexOf("=");
                                if (pos == -1) continue;
                                String varName = line.substring(0, pos);
                                String varValue = line.substring(pos + 1);
                                result.put(varName, varValue);
                            }
                        }
                        catch (IOException e) {
                            DLTKRSEPlugin.log(e);
                        }
                    }
                });
                t.start();
                try {
                    t.join(25000L);
                }
                catch (InterruptedException e) {
                    DLTKRSEPlugin.log(e);
                }
                process.destroy();
            }
            catch (CoreException e) {
                DLTKRSEPlugin.log(e);
            }
        }
        if (result.size() > 0) {
            hostToEnvironment.put(this.environment.getHost(), result);
        }
        long end = System.currentTimeMillis();
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(6);
            RSEPerfomanceStatistics.inc(5, end - start);
        }
        return result;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean isValidExecutableAndEquals(String possibleName, IPath path) {
        if (this.environment.getHost().getSystemType().isWindows()) {
            possibleName = possibleName.toLowerCase();
            String fName = path.removeFileExtension().toString().toLowerCase();
            String ext = path.getFileExtension();
            if (possibleName.equals(fName) && ("exe".equalsIgnoreCase(ext) || "bat".equalsIgnoreCase(ext))) {
                return true;
            }
        } else {
            String fName = path.lastSegment();
            if (fName.equals(possibleName)) {
                return true;
            }
        }
        return false;
    }
}

