/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model.operations;

import org.eclipse.dltk.dbgp.IDbgpFeature;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpResumeOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpStepIntoOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpStepOverOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpStepReturnOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpSuspendOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpTerminateOperation;
import org.eclipse.dltk.internal.debug.core.model.operations.IDbgpDebuggerFeedback;

public class DbgpDebugger {
    private final DbgpStepIntoOperation stepIntoOperation;
    private final DbgpStepOverOperation stepOverOperation;
    private final DbgpStepReturnOperation stepReturnOperation;
    private DbgpSuspendOperation suspendOperation;
    private final DbgpResumeOperation resumeOperation;
    private final DbgpTerminateOperation terminateOperation;
    private final IDbgpSession session;

    public DbgpDebugger(IScriptThread thread, final IDbgpDebuggerFeedback end) {
        this.session = thread.getDbgpSession();
        this.stepIntoOperation = new DbgpStepIntoOperation(thread, new DbgpOperation.IResultHandler(){

            public void finish(IDbgpStatus status, DbgpException e) {
                end.endStepInto(e, status);
            }
        });
        this.stepOverOperation = new DbgpStepOverOperation(thread, new DbgpOperation.IResultHandler(){

            public void finish(IDbgpStatus status, DbgpException e) {
                end.endStepOver(e, status);
            }
        });
        this.stepReturnOperation = new DbgpStepReturnOperation(thread, new DbgpOperation.IResultHandler(){

            public void finish(IDbgpStatus status, DbgpException e) {
                end.endStepReturn(e, status);
            }
        });
        try {
            this.suspendOperation = new DbgpSuspendOperation(thread, new DbgpOperation.IResultHandler(){

                public void finish(IDbgpStatus status, DbgpException e) {
                    end.endSuspend(e, status);
                }
            });
        }
        catch (DbgpException e) {
            e.printStackTrace();
        }
        this.resumeOperation = new DbgpResumeOperation(thread, new DbgpOperation.IResultHandler(){

            public void finish(IDbgpStatus status, DbgpException e) {
                end.endResume(e, status);
            }
        });
        this.terminateOperation = new DbgpTerminateOperation(thread, new DbgpOperation.IResultHandler(){

            public void finish(IDbgpStatus status, DbgpException e) {
                end.endTerminate(e, status);
            }
        });
    }

    public void stepInto() {
        this.stepIntoOperation.schedule();
    }

    public void stepOver() {
        this.stepOverOperation.schedule();
    }

    public void stepReturn() {
        this.stepReturnOperation.schedule();
    }

    public void suspend() {
        this.suspendOperation.schedule();
    }

    public void resume() {
        this.resumeOperation.schedule();
    }

    public void terminate() {
        this.terminateOperation.schedule();
    }

    public IDbgpFeature getFeature(String name) throws DbgpException {
        IDbgpCoreCommands core = this.session.getCoreCommands();
        return core.getFeature(name);
    }

    public void setFeature(String name, String value) throws DbgpException {
        IDbgpCoreCommands core = this.session.getCoreCommands();
        core.setFeature(name, value);
    }

    public boolean isFeatureSupported(String name) throws DbgpException {
        return this.getFeature(name).isSupported();
    }

    public boolean getFeatureBoolean(String name) throws DbgpException {
        return this.getFeature(name).getValue().equals("1");
    }

    public void setFeatureBoolean(String name, boolean value) throws DbgpException {
        this.setFeature(name, value ? "1" : "0");
    }

    public int getFeatureInteger(String name) throws DbgpException {
        return Integer.parseInt(this.getFeature(name).getValue());
    }

    public void setFeatureInteger(String name, int value) throws DbgpException {
        this.setFeature(name, Integer.toString(value));
    }

    public boolean isSupportsThreads() throws DbgpException {
        return this.getFeature("language_supports_threads").getValue().equals("1");
    }

    public String getLanguageName() throws DbgpException {
        return this.getFeature("language_name").getValue();
    }

    public String getLanguageVersion() throws DbgpException {
        return this.getFeature("language_version").getValue();
    }

    public String getEncoding() throws DbgpException {
        return this.getFeature("encoding").getValue();
    }

    public String getDataEncoding() throws DbgpException {
        return this.getFeature("data_encoding").getValue();
    }

    public String getProtocolVersion() throws DbgpException {
        return this.getFeature("protocol_version").getValue();
    }

    public boolean isSupportsAsync() throws DbgpException {
        return this.getFeature("supports_async").getValue().equals("1");
    }

    public String getBreakpointLanguages() throws DbgpException {
        return this.getFeature("breakpoint_languages").getValue();
    }

    public String getBreakpointTypes() throws DbgpException {
        return this.getFeature("breakpoint_types").getValue();
    }

    public boolean getMultipleSessions() throws DbgpException {
        return this.getFeature("multiple_sessions").getValue().equals("1");
    }

    public void setMultipleSessions(boolean value) throws DbgpException {
        this.setFeature("multiple_sessions", value ? "1" : "0");
    }

    public int getMaxChildren() throws DbgpException {
        return this.getFeatureInteger("max_children");
    }

    public void setMaxChildren(int value) throws DbgpException {
        this.setFeatureInteger("max_children", value);
    }

    public int getMaxData() throws DbgpException {
        return this.getFeatureInteger("max_data");
    }

    public void setMaxData(int value) throws DbgpException {
        this.setFeatureInteger("max_data", value);
    }

    public int getMaxDepth() throws DbgpException {
        return this.getFeatureInteger("max_depth");
    }

    public void setMaxDepth(int value) throws DbgpException {
        this.setFeatureInteger("max_depth", value);
    }

    public boolean isPostMortenSupported() throws DbgpException {
        return this.isFeatureSupported("supports_postmortem");
    }

    public boolean getPostMorten() throws DbgpException {
        return this.getFeatureBoolean("supports_postmortem");
    }

    public boolean isShowHiddenSupported() throws DbgpException {
        return this.isFeatureSupported("show_hidden");
    }

    public boolean getShowHidden() throws DbgpException {
        return this.getFeatureBoolean("show_hidden");
    }

    public void setShowHidden(boolean value) throws DbgpException {
        this.setFeatureBoolean("show_hidden", value);
    }

    public boolean isNotifyOkSupported() throws DbgpException {
        return this.isFeatureSupported("notify_ok");
    }

    public boolean getNotifyOk() throws DbgpException {
        return this.getFeatureBoolean("notify_ok");
    }

    public void setNotifyOk(boolean value) throws DbgpException {
        this.setFeatureBoolean("notify_ok", value);
    }

    protected void configureStdout(int value) throws DbgpException {
        IDbgpCoreCommands core = this.session.getCoreCommands();
        core.configureStdout(value);
    }

    public void disableStdout() throws DbgpException {
        this.configureStdout(0);
    }

    public void copyStdout() throws DbgpException {
        this.configureStdout(1);
    }

    public void redirectStdout() throws DbgpException {
        this.configureStdout(2);
    }

    protected void configureStderr(int value) throws DbgpException {
        IDbgpCoreCommands core = this.session.getCoreCommands();
        core.configureStderr(value);
    }

    public void disableStderr() throws DbgpException {
        this.configureStderr(0);
    }

    public void copyStderr() throws DbgpException {
        this.configureStderr(1);
    }

    public void redirectStderr() throws DbgpException {
        this.configureStderr(2);
    }

    protected void configureStdin(int value) throws DbgpException {
        IDbgpExtendedCommands extended = this.session.getExtendedCommands();
        extended.configureStdin(value);
    }

    public void disableStdin() throws DbgpException {
        this.configureStdin(0);
    }

    public void redirectStdin() throws DbgpException {
        this.configureStdin(1);
    }

    public static void printEngineInfo(DbgpDebugger d) throws DbgpException {
        System.out.println("language_supports_threads: " + d.isSupportsThreads());
        System.out.println("language_name: " + d.getLanguageName());
        System.out.println("language_version: " + d.getLanguageVersion());
        System.out.println("encoding: " + d.getEncoding());
        System.out.println("data_encoding: " + d.getDataEncoding());
        System.out.println("protocol_version: " + d.getProtocolVersion());
        System.out.println("supports_async: " + d.isSupportsAsync());
        System.out.println("breakpoint_languages: " + d.getBreakpointLanguages());
        System.out.println("breakpoint_types: " + d.getBreakpointTypes());
        System.out.println("multiple_sessions: " + d.getMultipleSessions());
        System.out.println("max_children: " + d.getMaxChildren());
        System.out.println("max_data: " + d.getMaxData());
        System.out.println("max_depth: " + d.getMaxDepth());
        if (d.isPostMortenSupported()) {
            System.out.println("Support of supports_postmortem: true, value: " + d.getPostMorten());
        } else {
            System.out.println("Support of supports_postmortem: false");
        }
        if (d.isShowHiddenSupported()) {
            System.out.println("Support of show_hidden: true, value: " + d.getShowHidden());
        } else {
            System.out.println("Support of show_hidden: false");
        }
        if (d.isNotifyOkSupported()) {
            System.out.println("Support of notify_ok: true, value: " + d.getNotifyOk());
        } else {
            System.out.println("Support of notify_ok: false");
        }
    }

    public IDbgpSession getSession() {
        return this.session;
    }
}

