/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.EFSFileHandle;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.internal.launching.execution.Messages;
import org.osgi.framework.Bundle;

public class EFSDeployment
implements IDeployment {
    private IFileStore root;
    private IEnvironment environment;

    public EFSDeployment(IEnvironment env, URI rootURI) throws CoreException {
        this.environment = env;
        this.root = EFS.getStore((URI)rootURI);
        this.root.mkdir(0, null);
        DeploymentManager.getInstance().addDeployment(this);
    }

    public IPath add(Bundle bundle, String bundlePath) throws IOException {
        try {
            IFileStore dest = this.root.getChild((IPath)new Path(bundlePath));
            Enumeration paths = bundle.getEntryPaths(bundlePath);
            if (paths != null) {
                dest.mkdir(0, null);
                while (paths.hasMoreElements()) {
                    String path = (String)paths.nextElement();
                    if (path.endsWith("/")) {
                        if (path.endsWith("/CVS/") || path.endsWith("/.svn/")) continue;
                        this.add(bundle, path);
                        continue;
                    }
                    EFSDeployment.copy(bundle.getEntry(path), this.root.getChild(path));
                }
            } else {
                URL url = bundle.getEntry(bundlePath);
                if (url == null) {
                    throw new IOException(MessageFormat.format(Messages.EFSDeployment_failedToLocateEntryForPath, bundlePath));
                }
                IFileStore parent = dest.getParent();
                if (parent != null) {
                    parent.mkdir(0, null);
                }
                EFSDeployment.copy(url, dest);
            }
        }
        catch (CoreException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return new Path(bundlePath);
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        int ch = -1;
        while ((ch = input.read()) != -1) {
            output.write(ch);
        }
    }

    /*
     * Exception decompiling
     */
    private static void copy(InputStream input, IFileStore file) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 52->56)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static void copy(URL url, IFileStore file) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 34->38)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void dispose() {
        block2: {
            try {
                this.root.delete(0, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        DeploymentManager.getInstance().removeDeployment(this);
    }

    public IPath getAbsolutePath() {
        return new Path(this.root.toURI().getPath());
    }

    public IFileHandle getFile(IPath deploymentPath) {
        return new EFSFileHandle(this.environment, this.root.getChild(deploymentPath));
    }

    public void mkdirs(IPath path) {
        block2: {
            try {
                this.root.getChild(path).mkdir(0, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public IPath add(InputStream input, String filename) throws IOException {
        IFileStore dest = this.root.getChild(filename);
        try {
            EFSDeployment.copy(input, dest);
        }
        catch (CoreException e) {
            throw new IOException(MessageFormat.format(Messages.EFSDeployment_failedToDeployStream, e.getMessage()));
        }
        return new Path(filename);
    }
}

