/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.buildpath;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.tests.model.ModelTestsPlugin;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public class BuildpathTests
extends ModifyingResourceTests {
    private static final String[] TEST_NATURE = new String[]{"org.eclipse.dltk.core.tests.testnature"};
    private static final String BUILDPATH_PRJ_0 = "Buildpath0";
    private static final String BUILDPATH_PRJ_1 = "Buildpath1";
    private static final String BUILDPATH_PRJ_2 = "Buildpath2";
    static /* synthetic */ Class class$0;

    public BuildpathTests(String name) {
        super("org.eclipse.dltk.core.tests", name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.tests.buildpath.BuildpathTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpScriptProject("ModelMembers");
        this.setUpScriptProject(BUILDPATH_PRJ_0);
        this.setUpScriptProject(BUILDPATH_PRJ_1);
        this.setUpScriptProject("p1");
        this.setUpScriptProject("p2");
    }

    private void assertEncodeDecodeEntry(String projectName, String expectedEncoded, IBuildpathEntry entry) {
        IScriptProject project = this.getScriptProject(projectName);
        String encoded = project.encodeBuildpathEntry(entry);
        this.assertSourceEquals("Unexpected encoded entry", expectedEncoded, encoded);
        IBuildpathEntry decoded = project.decodeBuildpathEntry(encoded);
        BuildpathTests.assertEquals((String)"Unexpected decoded entry", (Object)entry, (Object)decoded);
    }

    protected void assertStatus(String expected, IStatus status) {
        String actual = status.getMessage();
        expected.equals(actual);
        BuildpathTests.assertEquals((String)expected, (String)actual);
    }

    protected void assertStatus(String message, String expected, IStatus status) {
        String actual = status.getMessage();
        expected.equals(actual);
        BuildpathTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected File createFile(File parent, String name, String content) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        file.setLastModified(System.currentTimeMillis() + 2000L);
        return file;
    }

    protected File createFolder(File parent, String name) {
        File file = new File(parent, name);
        file.mkdirs();
        return file;
    }

    protected int numberOfCycleMarkers(IScriptProject scriptProject) throws CoreException {
        IMarker[] markers = scriptProject.getProject().findMarkers("org.eclipse.dltk.core.buildpath_problem", false, 0);
        int result = 0;
        int i = 0;
        int length = markers.length;
        while (i < length) {
            IMarker marker = markers[i];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(BUILDPATH_PRJ_0);
        this.deleteProject(BUILDPATH_PRJ_1);
        this.deleteProject("p1");
        this.deleteProject("p2");
        super.tearDownSuite();
    }

    public void test001() throws ModelException {
        ScriptProject project = (ScriptProject)this.getScriptProject(BUILDPATH_PRJ_0);
        BuildpathTests.assertNotNull((Object)project);
        IBuildpathEntry[] entrys = project.getRawBuildpath();
        BuildpathTests.assertEquals((int)3, (int)entrys.length);
        BuildpathTests.assertEquals((int)3, (int)entrys[0].getEntryKind());
        BuildpathTests.assertEquals((int)2, (int)entrys[1].getEntryKind());
        BuildpathTests.assertEquals((int)3, (int)entrys[2].getEntryKind());
        IModelElement[] children = project.getChildren();
        BuildpathTests.assertEquals((String)"Sould be 2 accessible project fragments", (int)2, (int)children.length);
        BuildpathTests.assertTrue((boolean)(children[0] instanceof IProjectFragment));
        BuildpathTests.assertTrue((boolean)(children[1] instanceof IProjectFragment));
        IProjectFragment fr0 = (IProjectFragment)children[0];
        IProjectFragment fr1 = (IProjectFragment)children[1];
        children = fr0.getChildren();
        BuildpathTests.assertEquals((int)1, (int)children.length);
        BuildpathTests.assertTrue((boolean)(children[0] instanceof IScriptFolder));
        IModelElement[] folderChildren = ((IScriptFolder)children[0]).getChildren();
        BuildpathTests.assertEquals((int)2, (int)folderChildren.length);
        BuildpathTests.assertTrue((boolean)(folderChildren[0] instanceof ISourceModule));
        BuildpathTests.assertEquals((String)"X.txt", (String)((ISourceModule)folderChildren[0]).getElementName());
        BuildpathTests.assertEquals((String)"X2.txt", (String)((ISourceModule)folderChildren[1]).getElementName());
        BuildpathTests.assertTrue((boolean)(folderChildren[1] instanceof ISourceModule));
        children = fr1.getChildren();
        BuildpathTests.assertEquals((int)1, (int)children.length);
        BuildpathTests.assertTrue((boolean)(children[0] instanceof IScriptFolder));
        folderChildren = ((IScriptFolder)children[0]).getChildren();
        BuildpathTests.assertEquals((int)1, (int)folderChildren.length);
        BuildpathTests.assertTrue((boolean)(folderChildren[0] instanceof ISourceModule));
        BuildpathTests.assertEquals((String)"X3.txt", (String)((ISourceModule)folderChildren[0]).getElementName());
    }

    public void test002() throws ModelException {
        ScriptProject project = (ScriptProject)this.getScriptProject(BUILDPATH_PRJ_0);
        ScriptProject cfr_ignored_0 = (ScriptProject)this.getScriptProject(BUILDPATH_PRJ_1);
        BuildpathTests.assertNotNull((Object)project);
        project.getProjectFragments();
        project.getResolvedBuildpath();
    }

    public void test003() throws ModelException {
        ScriptProject project = (ScriptProject)this.getScriptProject(BUILDPATH_PRJ_0);
        ScriptProject cfr_ignored_0 = (ScriptProject)this.getScriptProject(BUILDPATH_PRJ_1);
        BuildpathTests.assertNotNull((Object)project);
        project.getProjectFragments();
        project.getResolvedBuildpath();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test004() throws Exception {
        try {
            this.setUpScriptProject(BUILDPATH_PRJ_2);
            IScriptProject project = this.getScriptProject(BUILDPATH_PRJ_2);
            BuildpathTests.assertNotNull((Object)project);
            IBuildpathEntry[] entrys = project.getRawBuildpath();
            BuildpathTests.assertEquals((int)1, (int)entrys.length);
            BuildpathTests.assertEquals((int)1, (int)entrys[0].getEntryKind());
            IProjectFragment[] fragments = project.getProjectFragments();
            BuildpathTests.assertEquals((int)1, (int)fragments.length);
            BuildpathTests.assertTrue((boolean)(fragments[0] instanceof ArchiveProjectFragment));
            IProjectFragment fragment = fragments[0];
            fragment.getChildren();
            CorePrinter printer = new CorePrinter((OutputStream)System.out);
            ((ScriptProject)project).printNode(printer);
            printer.flush();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject(BUILDPATH_PRJ_2);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject(BUILDPATH_PRJ_2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test005() throws Exception {
        try {
            URL url = ModelTestsPlugin.getDefault().getBundle().getEntry("workspace/Buildpath3");
            URL res = FileLocator.resolve((URL)url);
            Path filePath = new Path(res.getFile());
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            IEnvironment env = LocalEnvironment.getInstance();
            newCP[originalCP.length] = DLTKCore.newExtLibraryEntry((IPath)EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)filePath));
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("OK", (IStatus)status);
            proj.setRawBuildpath(newCP, null);
            IProjectFragment[] fragments = proj.getProjectFragments();
            BuildpathTests.assertEquals((int)2, (int)fragments.length);
            CorePrinter printer = new CorePrinter((OutputStream)System.out, true);
            ((ScriptProject)proj).printNode(printer);
            printer.flush();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test006() throws Exception {
        try {
            IPath localPath;
            URL url = ModelTestsPlugin.getDefault().getBundle().getEntry("/workspace/Buildpath3");
            URL res = FileLocator.resolve((URL)url);
            IPath contPath = localPath = new Path("Testie").append(res.getFile().substring(1));
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newContainerEntry((IPath)contPath);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("OK", (IStatus)status);
            proj.setRawBuildpath(newCP, null);
            IProjectFragment[] fragments = proj.getProjectFragments();
            BuildpathTests.assertEquals((int)2, (int)fragments.length);
            CorePrinter printer = new CorePrinter((OutputStream)System.out, true);
            ((ScriptProject)proj).printNode(printer);
            printer.flush();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.deleteProject("P");
    }

    public void testEncodeDecodeEntry01() {
        this.assertEncodeDecodeEntry("P", "<buildpathentry kind=\"src\" path=\"src\"/>\n", DLTKCore.newSourceEntry((IPath)new Path("/P/src")));
    }

    public void testEncodeDecodeEntry02() {
        this.assertEncodeDecodeEntry("P", "<buildpathentry excluding=\"**/X.java\" including=\"**/Y.java\" kind=\"src\" path=\"src\">\n\t<attributes>\n\t\t<attribute name=\"attrName\" value=\"some value\"/>\n\t</attributes>\n</buildpathentry>\n", DLTKCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[]{new Path("**/Y.java")}, (IPath[])new IPath[]{new Path("**/X.java")}, (IBuildpathAttribute[])new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"attrName", (String)"some value")}));
    }

    public void testEncodeDecodeEntry03() {
        this.assertEncodeDecodeEntry("P1", "<buildpathentry kind=\"prj\" path=\"/P2\"/>\n", DLTKCore.newProjectEntry((IPath)new Path("/P2")));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEmptyContainer() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, null);
            this.startDeltas();
            DLTKCore.setBuildpathContainer((IPath)new Path("container/default"), (IScriptProject[])new IScriptProject[]{proj}, (IBuildpathContainer[])new IBuildpathContainer[]{new TestContainer((IPath)new Path("container/default"), new IBuildpathEntry[0])}, null);
            IBuildpathEntry container = DLTKCore.newContainerEntry((IPath)new Path("container/default"), (boolean)true);
            proj.setRawBuildpath(new IBuildpathEntry[]{container}, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CONTENT | BUILDPATH CHANGED}\n\tResourceDelta(/P/.buildpath)[*]");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testInvalidSourceFolder() throws CoreException {
        try {
            this.createScriptProject("P1i", TEST_NATURE, new String[]{""});
            IScriptProject proj = this.createScriptProject("P2i", TEST_NATURE, new String[]{""}, new String[]{"/P1i/src1/src2"});
            this.assertMarkers("Unexpected markers", "Illegal path for required project: '/P1i/src1/src2' in project P2i", proj);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P1i");
            this.deleteProject("P2i");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P1i");
        this.deleteProject("P2i");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation01() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = newCP[0];
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should have detected duplicate entries on the buildpath", "Build path contains duplicate entry: 'src' for project P", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathLibraryValidation01() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("Pv0", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            IEnvironment env = LocalEnvironment.getInstance();
            IPath libPath = EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)new Path("/opt2"));
            newCP[originalCP.length] = DLTKCore.newExtLibraryEntry((IPath)libPath);
            IModelStatus status = BuildpathEntry.validateBuildpathEntry((IScriptProject)proj, (IBuildpathEntry)newCP[originalCP.length], (boolean)false);
            this.assertStatus("should detect not pressent folders", "Required library cannot denote external folder or archive: '" + EnvironmentPathUtils.getLocalPath((IPath)libPath).toString() + "' for project Pv0", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("Pv0");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("Pv0");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation02() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"));
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should have detected nested source folders on the buildpath", "Cannot nest 'P/src' inside 'P'. To enable the nesting exclude 'src/' from 'P'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation03() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newLibraryEntry((IPath)new Path("/P/src/lib"));
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should have detected library folder nested inside source folder on the Buildpath", "Cannot nest 'P/src/lib' inside 'P/src'. To enable the nesting exclude 'lib/' from 'P/src'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation05() throws CoreException {
        IScriptProject[] p = null;
        try {
            p = new IScriptProject[]{this.createScriptProject("P0v", TEST_NATURE, new String[]{"src0", "src1"}), this.createScriptProject("P1v", TEST_NATURE, new String[]{"src1"})};
            DLTKCore.setBuildpathContainer((IPath)new Path("container/default"), (IScriptProject[])new IScriptProject[]{p[0]}, (IBuildpathContainer[])new IBuildpathContainer[]{new TestContainer((IPath)new Path("container/default"), new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)new Path("/P0v/src0"))})}, null);
            IBuildpathEntry[] newBuildpath = new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)new Path("/P0v/src1")), DLTKCore.newContainerEntry((IPath)new Path("container/default"))};
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)p[0], (IBuildpathEntry[])newBuildpath);
            this.assertStatus("should not have detected external source folder through a container on the Buildpath", "OK", (IStatus)status);
            status = BuildpathEntry.validateBuildpathEntry((IScriptProject)p[0], (IBuildpathEntry)newBuildpath[1], (boolean)true);
            this.assertStatus("should have detected external source folder through a container on the Buildpath", "Invalid buildpath container: 'container/default' in project P0v", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P0v");
            this.deleteProject("P1v");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P0v");
        this.deleteProject("P1v");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation06() throws CoreException {
        IScriptProject[] p = null;
        try {
            p = new IScriptProject[]{this.createScriptProject("P0", TEST_NATURE, new String[]{"src"})};
            IBuildpathEntry[] newBuildpath = new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)new Path("/P0")), DLTKCore.newSourceEntry((IPath)new Path("/P0/src"))};
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)p[0], (IBuildpathEntry[])newBuildpath);
            this.assertStatus("should have detected nested source folder", "Cannot nest 'P0/src' inside 'P0'. To enable the nesting exclude 'src/' from 'P0'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P0");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P0");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation07() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("src/")});
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should have allowed nested source folders with exclusion on the buildpath", "OK", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation08() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[0]);
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("lib/")});
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should have allowed nested lib folders with exclusion on the buildpath", "OK", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation15() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("**/src")});
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("End exclusion filter 'src' with / to fully exclude 'P/src'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation21() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[0]);
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[]{new Path("**/src")});
            Hashtable<String, String> options = new Hashtable<String, String>(5);
            options.put("org.eclipse.dltk.core.buildpath.exclusionPatterns", "disabled");
            proj.setOptions(options);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("Inclusion or exclusion patterns are disabled in project P, cannot selectively include or exclude from entry: 'src'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation23() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[0]);
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 2];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P/"), (IPath[])new IPath[]{new Path("src/")}, (IPath[])BuildpathEntry.EXCLUDE_NONE);
            newCP[originalCP.length + 1] = DLTKCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[0], (IPath[])BuildpathEntry.EXCLUDE_NONE);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("Cannot nest 'P/src' inside 'P/'. To enable the nesting exclude 'src/' from 'P/'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation34() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("src/")}, (IPath[])new IPath[0], null);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should not have allowed nested source folders with inclusion on the buildpath", "Cannot nest 'P/src' inside 'P'. To enable the nesting exclude 'src/' from 'P'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation36() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"), (IPath[])new IPath[]{new Path("**/src")}, (IPath[])new Path[0], null);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("OK", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation37() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[0]);
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[]{new Path("**/src")}, (IPath[])new Path[0], null);
            Hashtable<String, String> options = new Hashtable<String, String>(5);
            options.put("org.eclipse.dltk.core.buildpath.exclusionPatterns", "disabled");
            proj.setOptions(options);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("Inclusion or exclusion patterns are disabled in project P, cannot selectively include or exclude from entry: 'src'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathValidation42() throws CoreException {
        try {
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            proj.setOption("org.eclipse.dltk.core.buildpath.exclusionPatterns", "disabled");
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newSourceEntry((IPath)new Path("/P"));
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("should have detected nested source folders on the buildpath", "Cannot nest 'P/src' inside 'P'. To allow the nesting enable use of exclusion patterns in the preferences of project 'P' and exclude 'src/' from 'P'", (IStatus)status);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathWithDuplicateEntries() throws CoreException {
        try {
            IScriptProject project = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] cp = project.getRawBuildpath();
            IBuildpathEntry[] newCp = new IBuildpathEntry[cp.length * 2];
            System.arraycopy(cp, 0, newCp, 0, cp.length);
            System.arraycopy(cp, 0, newCp, cp.length, cp.length);
            try {
                project.setRawBuildpath(newCp, null);
            }
            catch (ModelException modelException) {
                Object var4_4 = null;
                this.deleteProject("P");
                return;
            }
            BuildpathTests.assertTrue((String)"Setting the buildpath with two entries specifying the same path should fail", (boolean)false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathWithNonExistentProjectEntry() throws CoreException {
        try {
            IBuildpathEntry newEntry;
            IScriptProject project = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalPath = project.getRawBuildpath();
            IProjectFragment[] originalRoots = project.getProjectFragments();
            IBuildpathEntry[] newPath = new IBuildpathEntry[originalPath.length + 1];
            System.arraycopy(originalPath, 0, newPath, 0, originalPath.length);
            newPath[originalPath.length] = newEntry = DLTKCore.newProjectEntry((IPath)new Path("/NoProject"), (boolean)false);
            project.setRawBuildpath(newPath, null);
            IBuildpathEntry[] getPath = project.getRawBuildpath();
            BuildpathTests.assertTrue((String)"should be the same length", (getPath.length == newPath.length ? 1 : 0) != 0);
            int i = 0;
            while (true) {
                block5: {
                    if (i < getPath.length) break block5;
                }
                BuildpathTests.assertTrue((String)"entries should be the same", (boolean)getPath[i].equals(newPath[i]));
                ++i;
            }
            IProjectFragment[] newRoots = project.getProjectFragments();
            BuildpathTests.assertTrue((String)"Should be the same number of roots", (originalRoots.length == newRoots.length ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < newRoots.length) {
                BuildpathTests.assertTrue((String)"roots should be the same", (boolean)originalRoots[i2].equals(newRoots[i2]));
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathWithNonExistentSourceEntry() throws CoreException {
        try {
            IBuildpathEntry newEntry;
            IScriptProject project = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalPath = project.getRawBuildpath();
            IProjectFragment[] originalRoots = project.getProjectFragments();
            IBuildpathEntry[] newPath = new IBuildpathEntry[originalPath.length + 1];
            System.arraycopy(originalPath, 0, newPath, 0, originalPath.length);
            newPath[originalPath.length] = newEntry = DLTKCore.newSourceEntry((IPath)new Path("/P/moreSource"));
            project.setRawBuildpath(newPath, null);
            IBuildpathEntry[] getPath = project.getRawBuildpath();
            BuildpathTests.assertTrue((String)"should be the same length", (getPath.length == newPath.length ? 1 : 0) != 0);
            int i = 0;
            while (true) {
                block5: {
                    if (i < getPath.length) break block5;
                }
                BuildpathTests.assertTrue((String)"entries should be the same", (boolean)getPath[i].equals(newPath[i]));
                ++i;
            }
            IProjectFragment[] newRoots = project.getProjectFragments();
            BuildpathTests.assertTrue((String)"Should be the same number of roots", (originalRoots.length == newRoots.length ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < newRoots.length) {
                BuildpathTests.assertTrue((String)"roots should be the same", (boolean)originalRoots[i2].equals(newRoots[i2]));
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCycleReport() throws CoreException {
        try {
            IScriptProject p1 = this.createScriptProject("p1_", TEST_NATURE, new String[]{""});
            IScriptProject p2 = this.createScriptProject("p2_", TEST_NATURE, new String[]{""});
            IScriptProject p3 = this.createScriptProject("p3_", TEST_NATURE, new String[]{""}, new String[]{"/p2_"});
            IScriptProject[] projects = new IScriptProject[]{p1, p2, p3};
            int cycleMarkerCount = 0;
            int i = 0;
            while (true) {
                block5: {
                    if (i < projects.length) break block5;
                }
                cycleMarkerCount += this.numberOfCycleMarkers(projects[i]);
                ++i;
            }
            BuildpathTests.assertTrue((String)"Should have no cycle markers", (cycleMarkerCount == 0 ? 1 : 0) != 0);
            IBuildpathEntry[] originalP1CP = p1.getRawBuildpath();
            IBuildpathEntry[] originalP2CP = p2.getRawBuildpath();
            int length = originalP2CP.length;
            IBuildpathEntry[] newCP = new IBuildpathEntry[length + 1];
            System.arraycopy(originalP2CP, 0, newCP, 0, length);
            newCP[length] = DLTKCore.newProjectEntry((IPath)p1.getProject().getFullPath(), (boolean)false);
            p2.setRawBuildpath(newCP, null);
            length = originalP1CP.length;
            newCP = new IBuildpathEntry[length + 1];
            System.arraycopy(originalP1CP, 0, newCP, 0, length);
            newCP[length] = DLTKCore.newProjectEntry((IPath)p3.getProject().getFullPath(), (boolean)false);
            p1.setRawBuildpath(newCP, null);
            BuildpathTests.waitForAutoBuild();
            cycleMarkerCount = 0;
            int i2 = 0;
            while (true) {
                block6: {
                    if (i2 < projects.length) break block6;
                    BuildpathTests.assertEquals((String)"Unexpected number of projects involved in a buildpath cycle", (int)3, (int)cycleMarkerCount);
                    break;
                }
                cycleMarkerCount += this.numberOfCycleMarkers(projects[i2]);
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.deleteProjects(new String[]{"p1_", "p2_", "p3_"});
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        this.deleteProjects(new String[]{"p1_", "p2_", "p3_"});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEmptyBuildpath() throws CoreException {
        IScriptProject project = this.createScriptProject("P", TEST_NATURE, new String[]{""});
        try {
            this.startDeltas();
            this.setBuildpath(project, new IBuildpathEntry[0]);
            IBuildpathEntry[] cp = project.getRawBuildpath();
            BuildpathTests.assertTrue((String)"buildpath should have no entries", (cp.length == 0 ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | BUILDPATH CHANGED}\n\t<project root>[*]: {REMOVED FROM BUILDPATH}\n\tResourceDelta(/P/.buildpath)[*]");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEncoding() throws CoreException {
        try {
            this.createScriptProject("P", TEST_NATURE, new String[]{"src\u3400"});
            IFile file = this.getFile("/P/.buildpath");
            String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)file, (String)"UTF-8"));
            encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter(encodedContents);
            BuildpathTests.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<buildpath>\n\t<buildpathentry kind=\"src\" path=\"src\u3400\"/>\n</buildpath>\n", (String)encodedContents);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildpathCrossProject() throws CoreException {
        IScriptProject project = this.createScriptProject("P1c", TEST_NATURE, new String[]{""});
        this.createScriptProject("P2c", TEST_NATURE, new String[0]);
        try {
            this.startDeltas();
            IProjectFragment oldRoot = this.getProjectFragment("P1c", "");
            IBuildpathEntry projectEntry = DLTKCore.newProjectEntry((IPath)new Path("/P2c"), (boolean)false);
            IBuildpathEntry[] newBuildpath = new IBuildpathEntry[]{projectEntry};
            project.setRawBuildpath(newBuildpath, null);
            project.getProjectFragments();
            IModelElementDelta removedDelta = this.getDeltaFor((IModelElement)oldRoot, true);
            this.assertDeltas("Unexpected delta", "<project root>[*]: {REMOVED FROM BUILDPATH}", removedDelta);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.stopDeltas();
            this.deleteProjects(new String[]{"P1c", "P2c"});
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.stopDeltas();
        this.deleteProjects(new String[]{"P1c", "P2c"});
    }

    public class TestContainer
    implements IBuildpathContainer {
        IPath path;
        IBuildpathEntry[] entries;

        TestContainer(IPath path, IBuildpathEntry[] entries) {
            this.path = path;
            this.entries = entries;
        }

        public IPath getPath() {
            return this.path;
        }

        public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
            return this.entries;
        }

        public String getDescription(IScriptProject project) {
            return this.path.toString();
        }

        public int getKind() {
            return 0;
        }

        public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
            return null;
        }
    }
}

