/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.python.internal.ui.rules.PythonFloatNumberRule;
import org.eclipse.dltk.python.internal.ui.text.PythonDecoratorDetector;
import org.eclipse.dltk.python.internal.ui.text.PythonWhitespaceDetector;
import org.eclipse.dltk.python.internal.ui.text.PythonWordDetector;
import org.eclipse.dltk.python.internal.ui.text.PythonWordRule;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class PythonCodeScanner
extends AbstractScriptScanner {
    private static String[] fgKeywords = new String[]{"and", "del", "for", "is", "raise", "assert", "elif", "from", "lambda", "break", "else", "global", "not", "try", "class", "except", "if", "or", "while", "continue", "exec", "import", "pass", "yield", "def", "finally", "in", "print", "self", "with", "as"};
    private static String fgReturnKeyword = "return";
    private static String[] fgTokenProperties = new String[]{"DLTK_single_line_comment", "DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "DLTK_class_definition", "DLTK_function_definition", "DLTK_decorator"};

    public PythonCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = this.getToken("DLTK_keyword");
        Token keywordReturn = this.getToken("DLTK_keyword_return");
        Token comment = this.getToken("DLTK_single_line_comment");
        Token other = this.getToken("DLTK_default");
        Token cls = this.getToken("DLTK_class_definition");
        Token def = this.getToken("DLTK_function_definition");
        Token number = this.getToken("DLTK_number");
        Token decorator = this.getToken("DLTK_decorator");
        rules.add(new EndOfLineRule("#", (IToken)comment));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new PythonWhitespaceDetector()));
        PythonWordRule wordRule = new PythonWordRule(new PythonWordDetector(), (IToken)other, (IToken)cls, (IToken)def);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        wordRule.addWord(fgReturnKeyword, (IToken)keywordReturn);
        rules.add(wordRule);
        rules.add(new WordRule((IWordDetector)new PythonDecoratorDetector(), (IToken)decorator));
        rules.add(new PythonFloatNumberRule((IToken)number));
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

