/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core.externalchecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.validators.core.AbstractValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerMarker;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerProblem;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerWildcardManager;
import org.eclipse.dltk.validators.internal.core.externalchecker.Rule;
import org.eclipse.dltk.validators.internal.core.externalchecker.WildcardMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ExternalChecker
extends AbstractValidator {
    private static final String EXTENSIONS = "scriptPattrn";
    private String arguments;
    private IPath commmand;
    boolean initialized = false;
    private static final String ARGUMENTS = "arguments";
    private static final String COMMAND = "command";
    private List rules = new ArrayList();
    private String extensions;

    public void setCommand(String text) {
        this.commmand = new Path(text);
    }

    public void setRules(Vector list) {
        this.rules.clear();
        int i = 0;
        while (i < list.size()) {
            this.rules.add((Rule)list.get(i));
            ++i;
        }
    }

    public IPath getCommand() {
        return this.commmand;
    }

    public ExternalCheckerProblem parseProblem(String problem) {
        List wlist = ExternalCheckerWildcardManager.loadCustomWildcards();
        int i = 0;
        while (i < this.rules.size()) {
            block4: {
                Rule rule = (Rule)this.rules.get(i);
                try {
                    WildcardMatcher wmatcher = new WildcardMatcher(wlist);
                    ExternalCheckerProblem cproblem = wmatcher.match(rule, problem);
                    if (cproblem != null) {
                        return cproblem;
                    }
                }
                catch (Exception x) {
                    if (!DLTKCore.DEBUG) break block4;
                    System.out.println(x.toString());
                }
            }
            ++i;
        }
        return null;
    }

    public ExternalChecker(String id, String name, IValidatorType type) {
        super(id, name, type);
        this.arguments = "%f";
        this.commmand = new Path("");
        this.extensions = "*";
    }

    protected ExternalChecker(String id, IValidatorType type) {
        super(id, null, type);
        this.arguments = "%f";
        this.commmand = new Path("");
    }

    protected ExternalChecker(String id, Element element, IValidatorType type) throws IOException {
        super(id, null, type);
        this.loadInfo(element);
    }

    public void loadInfo(Element element) {
        if (this.initialized) {
            return;
        }
        super.loadFrom(element);
        this.initialized = true;
        this.commmand = new Path(element.getAttribute(COMMAND));
        this.arguments = element.getAttribute(ARGUMENTS);
        this.extensions = element.getAttribute(EXTENSIONS);
        NodeList nodes = element.getChildNodes();
        this.rules.clear();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeName() == "rule") {
                NamedNodeMap map = nodes.item(i).getAttributes();
                String ruletext = map.getNamedItem("TEXT").getNodeValue();
                String ruletype = map.getNamedItem("TYPE").getNodeValue();
                Rule r = new Rule(ruletext, ruletype);
                this.rules.add(r);
            }
            ++i;
        }
    }

    public void storeTo(Document doc, Element element) {
        super.storeTo(doc, element);
        element.setAttribute(ARGUMENTS, this.arguments);
        element.setAttribute(COMMAND, this.commmand.toOSString());
        element.setAttribute(EXTENSIONS, this.extensions);
        int i = 0;
        while (i < this.rules.size()) {
            Element elem = doc.createElement("rule");
            elem.setAttribute("TEXT", ((Rule)this.rules.get(i)).getDescription());
            elem.setAttribute("TYPE", ((Rule)this.rules.get(i)).getType());
            element.appendChild(elem);
            ++i;
        }
    }

    protected static IMarker reportErrorProblem(IResource resource, ExternalCheckerProblem problem, int start, int end) throws CoreException {
        return ExternalCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription(), 2, 1);
    }

    protected static IMarker reportWarningProblem(IResource resource, ExternalCheckerProblem problem, int start, int end) throws CoreException {
        return ExternalCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription(), 1, 1);
    }

    public void setArguments(String arguments) {
        this.initialized = true;
        this.arguments = arguments;
    }

    public String getArguments() {
        return this.arguments;
    }

    public IStatus validate(IResource resource, OutputStream console) {
        return Status.OK_STATUS;
    }

    public IStatus validate(ISourceModule module, OutputStream console) {
        block18: {
            IResource resource;
            block16: {
                String elementName = module.getElementName();
                String[] split = this.extensions.split(";");
                boolean found = false;
                int i = 0;
                while (i < split.length) {
                    if (elementName.endsWith(split[i]) || split[i].equals("*")) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (this.extensions.equals("")) {
                    found = true;
                }
                if (!found) {
                    return Status.OK_STATUS;
                }
                resource = module.getResource();
                if (resource == null) {
                    return new Status(4, "org.eclipse.dltk.validators.core", "SourceModule resource is null");
                }
                try {
                    ExternalCheckerMarker.clearMarkers(resource);
                }
                catch (CoreException e2) {
                    if (!DLTKCore.DEBUG) break block16;
                    e2.printStackTrace();
                }
            }
            ArrayList<String> lines = new ArrayList<String>();
            String com = this.commmand.toOSString();
            String args = this.processArguments(resource);
            String[] sArgs = args.split("::");
            ArrayList<String> coms = new ArrayList<String>();
            coms.add(com);
            int i = 0;
            while (i < sArgs.length) {
                coms.add(sArgs[i]);
                ++i;
            }
            String[] extcom = coms.toArray(new String[coms.size()]);
            BufferedReader input = null;
            Process process = null;
            try {
                block17: {
                    try {
                        process = DebugPlugin.exec((String[])extcom, null);
                    }
                    catch (Throwable e) {
                        if (!DLTKCore.DEBUG) break block17;
                        System.out.println(e.toString());
                    }
                }
                input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (console != null) {
                        console.write((String.valueOf(line) + "\n").getBytes());
                    }
                    lines.add(line);
                }
                String content = "";
                content = module.getSource();
                ExternalCheckerCodeModel model = new ExternalCheckerCodeModel(content);
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    String line1 = (String)iterator.next();
                    ExternalCheckerProblem problem = this.parseProblem(line1);
                    if (problem == null) continue;
                    int[] bounds = model.getBounds(problem.getLineNumber() - 1);
                    if (problem.getType().indexOf("Error") != -1) {
                        ExternalChecker.reportErrorProblem(resource, problem, bounds[0], bounds[1]);
                        continue;
                    }
                    if (problem.getType().indexOf("Warning") == -1) continue;
                    ExternalChecker.reportWarningProblem(resource, problem, bounds[0], bounds[1]);
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block18;
                System.out.println(e.toString());
            }
        }
        return Status.OK_STATUS;
    }

    public void setNewRule(Rule s) {
        this.rules.add(s);
    }

    public Rule getRule(int index) {
        if (index < this.rules.size()) {
            return (Rule)this.rules.get(index);
        }
        return null;
    }

    public int getNRules() {
        return this.rules.size();
    }

    private String processArguments(IResource resource) {
        String path = resource.getLocation().makeAbsolute().toOSString();
        String arguments = this.arguments;
        String user = this.replaceSequence(arguments.replaceAll("\t", "::").replaceAll(" ", "::"), 'f', path);
        String result = "";
        return String.valueOf(result) + "::" + user;
    }

    private String replaceSequence(String from, char pattern, String value) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < from.length()) {
            char c = from.charAt(i);
            if (c == '%' && i < from.length() - 1 && from.charAt(i + 1) == pattern) {
                buffer.append(value);
                ++i;
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean isValidatorValid() {
        IPath path = this.commmand;
        File file = new File(path.toOSString());
        return file.exists();
    }

    public void clean(ISourceModule module) {
        this.clean(module.getResource());
    }

    public void clean(IResource resource) {
        block2: {
            try {
                ExternalCheckerMarker.clearMarkers(resource);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String scriptPattern) {
        this.extensions = scriptPattern;
    }

    private static class ExternalCheckerCodeModel {
        private String[] codeLines;
        private int[] codeLineLengths;

        public ExternalCheckerCodeModel(String code) {
            this.codeLines = code.split("\n");
            int count = this.codeLines.length;
            this.codeLineLengths = new int[count];
            int sum = 0;
            int i = 0;
            while (i < count) {
                this.codeLineLengths[i] = sum;
                sum += this.codeLines[i].length() + 1;
                ++i;
            }
        }

        public int[] getBounds(int lineNumber) {
            if (this.codeLines.length <= lineNumber) {
                int[] nArray = new int[2];
                nArray[1] = 1;
                return nArray;
            }
            String codeLine = this.codeLines[lineNumber];
            String trimmedCodeLine = codeLine.trim();
            int start = this.codeLineLengths[lineNumber] + codeLine.indexOf(trimmedCodeLine);
            int end = start + trimmedCodeLine.length();
            return new int[]{start, end};
        }
    }
}

