/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.LazyScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.MethodProposalInfo;
import org.eclipse.dltk.ui.text.completion.ProposalContextInformation;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class ScriptMethodCompletionProposal
extends LazyScriptCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private int fContextInformationPosition;

    public ScriptMethodCompletionProposal(CompletionProposal proposal, ScriptContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == '(') {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (this.needsLinkedMode()) {
            this.setUpLinkedMode(document, ')');
        }
    }

    protected boolean needsLinkedMode() {
        return this.hasArgumentList() && this.hasParameters();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.hasArgumentList()) {
            String completion = String.valueOf(this.fProposal.getName());
            if (this.isCamelCaseMatching()) {
                String prefix = this.getPrefix(document, completionOffset);
                return this.getCamelCaseCompound(prefix, completion);
            }
            return completion;
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 5 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 10) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = false;
        }
        return this.fHasParameters;
    }

    protected boolean hasArgumentList() {
        if (10 == this.fProposal.getKind()) {
            return false;
        }
        IPreferenceStore preferenceStore = DLTKUIPlugin.getDefault().getPreferenceStore();
        boolean noOverwrite = preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        char[] completion = this.fProposal.getCompletion();
        return !this.isInScriptdoc() && completion.length > 0 && (noOverwrite || completion[completion.length - 1] == ')');
    }

    protected String computeReplacementString() {
        if (!this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProposal.getName());
        buffer.append("(");
        if (this.hasParameters()) {
            this.setCursorPosition(buffer.length());
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected ProposalInfo computeProposalInfo() {
        IScriptProject project = this.fInvocationContext.getProject();
        if (project != null) {
            return new MethodProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    public void setContextInformationPosition(int contextInformationPosition) {
        this.fContextInformationPosition = contextInformationPosition;
    }

    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        String word = this.getDisplayString();
        if (this.isInScriptdoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        }
        return this.isPrefix(prefix, word);
    }

    protected void handleSmartTrigger(IDocument document, char trigger, int referenceOffset) throws BadLocationException {
    }

    protected boolean isSmartTrigger(char trigger) {
        return false;
    }
}

