/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;

public class TclCallProcessor
implements ICallProcessor {
    public static final int GENERICS_AGNOSTIC_MATCH_RULE = 24;
    private SearchEngine searchEngine = new SearchEngine();

    public Map process(final IModelElement parent, IModelElement element, IDLTKSearchScope scope, IProgressMonitor monitor) {
        final HashMap elements = new HashMap();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                if (match.getAccuracy() != 0) {
                    return;
                }
                if (match.isInsideDocComment()) {
                    return;
                }
                if (match.getElement() != null && match.getElement() instanceof IModelElement) {
                    IModelElement member = (IModelElement)match.getElement();
                    ISourceModule module = (ISourceModule)member.getAncestor(5);
                    SimpleReference ref = new SimpleReference(match.getOffset(), match.getOffset() + match.getLength(), "");
                    try {
                        IModelElement[] e = module.codeSelect(match.getOffset(), 1);
                        int j = 0;
                        while (j < e.length) {
                            if (e[j].equals(parent)) {
                                elements.put(ref, member);
                            }
                            ++j;
                        }
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)element, (int)1, (int)24);
        try {
            this.searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return elements;
    }
}

