/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.internal.parser.TclSourceParser;

public class TclExecuteExpression
extends Expression {
    private String fExceuteContent;
    private char[] fileName = null;

    public TclExecuteExpression(int start, int end, String content) {
        this.setStart(start);
        this.setEnd(end);
        this.fExceuteContent = content;
    }

    public int getKind() {
        return 10004;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            List statements = this.parseExpression();
            if (statements != null) {
                int i = 0;
                while (i < statements.size()) {
                    ASTNode nde = (ASTNode)statements.get(i);
                    nde.traverse(visitor);
                    ++i;
                }
            }
            visitor.endvisit((Expression)this);
        }
    }

    public String getExpression() {
        return this.fExceuteContent;
    }

    public List parseExpression() {
        return this.parseExpression(this.sourceStart() + 1);
    }

    public List parseExpression(int startFrom) {
        if (this.fExceuteContent == null) {
            return null;
        }
        String content = this.fExceuteContent.substring(1, this.fExceuteContent.length() - 1);
        TclSourceParser parser = null;
        try {
            parser = (TclSourceParser)DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return new ArrayList();
        }
        parser.setCurrentPosition(startFrom);
        ModuleDeclaration module = parser.parse(null, content.toCharArray(), null);
        return module.getStatements();
    }

    public String toString() {
        return this.fExceuteContent;
    }
}

