/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;

public abstract class AbstractScriptBreakpoint
extends Breakpoint
implements IScriptBreakpoint {
    public static final String BREAKPOINT = "org.eclipse.dltk.script_breakpoint";
    private static final String IDENTIFIER = "org.eclipse.dltk.script_breakpoint.id";
    private static final String HIT_COUNT = "org.eclipse.dltk.script_breakpoint.hit_count";
    private static final String EXPRESSION = "org.eclipse.dltk.script_breakpoint.expression";
    private static final String EXPRESSION_STATE = "org.eclipse.dltk.script_breakpoint.expression.state";
    private static final String HIT_VALUE = "org.eclipse.dltk.script_breakpoint.hit_value";
    private static final String HIT_CONDITION = "org.eclipse.dltk.script_breakpoint.hit_condition";

    public static URI makeUri(IResource resource) {
        try {
            return new URI("file", "///" + resource.getLocation().toPortableString(), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void addScriptBreakpointAttributes(Map attributes, String debugModelId, boolean enabled) {
        attributes.put("org.eclipse.debug.core.id", debugModelId);
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
    }

    public String getModelIdentifier() {
        try {
            return this.ensureMarker().getAttribute("org.eclipse.debug.core.id", null);
        }
        catch (DebugException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getIdentifier() throws CoreException {
        return this.ensureMarker().getAttribute(IDENTIFIER, null);
    }

    public void setIdentifier(String id) throws CoreException {
        this.setAttribute(IDENTIFIER, id);
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int value) throws CoreException {
        this.ensureMarker().setAttribute(HIT_COUNT, value);
    }

    public int getHitValue() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_VALUE, -1);
    }

    public void setHitValue(int hitValue) throws CoreException {
        if (this.getHitValue() != hitValue) {
            this.setAttribute(HIT_VALUE, hitValue);
        }
    }

    public int getHitCondition() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_CONDITION, -1);
    }

    public void setHitCondition(int condition) throws CoreException {
        if (this.getHitCondition() != condition) {
            this.setAttribute(HIT_CONDITION, condition);
        }
    }

    public String getResourceName() throws CoreException {
        return this.ensureMarker().getResource().getName();
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute(EXPRESSION, null);
    }

    public void setExpression(String expression) throws CoreException {
        this.ensureMarker().setAttribute(EXPRESSION, (Object)expression);
    }

    public boolean getExpressionState() throws CoreException {
        return this.ensureMarker().getAttribute(EXPRESSION_STATE, false);
    }

    public void setExpressionState(boolean state) throws CoreException {
        if (this.getExpressionState() != state) {
            this.setAttribute(EXPRESSION_STATE, state);
        }
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }
}

